/*
 * Decompiled with CFR 0.152.
 */
package org.violet.common.core.support;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.security.ProtectionDomain;
import java.util.HashMap;
import org.springframework.asm.ClassVisitor;
import org.springframework.asm.Type;
import org.springframework.cglib.core.AbstractClassGenerator;
import org.springframework.cglib.core.ClassEmitter;
import org.springframework.cglib.core.CodeEmitter;
import org.springframework.cglib.core.Constants;
import org.springframework.cglib.core.Converter;
import org.springframework.cglib.core.EmitUtils;
import org.springframework.cglib.core.KeyFactory;
import org.springframework.cglib.core.Local;
import org.springframework.cglib.core.MethodInfo;
import org.springframework.cglib.core.ReflectUtils;
import org.springframework.cglib.core.Signature;
import org.springframework.cglib.core.TypeUtils;
import org.violet.common.core.util.BeanUtil;

public abstract class BaseBeanCopier {
    private static final BeanCopierKey KEY_FACTORY = (BeanCopierKey)KeyFactory.create(BeanCopierKey.class);
    private static final Type CONVERTER = TypeUtils.parseType((String)"org.springframework.cglib.core.Converter");
    private static final Type BEAN_COPIER = TypeUtils.parseType((String)BaseBeanCopier.class.getName());
    private static final Signature COPY = new Signature("copy", Type.VOID_TYPE, new Type[]{Constants.TYPE_OBJECT, Constants.TYPE_OBJECT, CONVERTER});
    private static final Signature CONVERT = TypeUtils.parseSignature((String)"Object convert(Object, Class, Object)");

    public static BaseBeanCopier create(Class source, Class target, boolean useConverter) {
        return BaseBeanCopier.create(source, target, null, useConverter);
    }

    public static BaseBeanCopier create(Class source, Class target, ClassLoader classLoader, boolean useConverter) {
        Generator gen = classLoader == null ? new Generator() : new Generator(classLoader);
        gen.setSource(source);
        gen.setTarget(target);
        gen.setUseConverter(useConverter);
        return gen.create();
    }

    public abstract void copy(Object var1, Object var2, Converter var3);

    public static class Generator
    extends AbstractClassGenerator {
        private static final AbstractClassGenerator.Source SOURCE = new AbstractClassGenerator.Source(BaseBeanCopier.class.getName());
        private final ClassLoader classLoader;
        private Class source;
        private Class target;
        private boolean useConverter;

        Generator() {
            super(SOURCE);
            this.classLoader = null;
        }

        Generator(ClassLoader classLoader) {
            super(SOURCE);
            this.classLoader = classLoader;
        }

        public void setSource(Class source) {
            if (!Modifier.isPublic(source.getModifiers())) {
                this.setNamePrefix(source.getName());
            }
            this.source = source;
        }

        public void setTarget(Class target) {
            if (!Modifier.isPublic(target.getModifiers())) {
                this.setNamePrefix(target.getName());
            }
            this.target = target;
        }

        public void setUseConverter(boolean useConverter) {
            this.useConverter = useConverter;
        }

        protected ClassLoader getDefaultClassLoader() {
            return this.target.getClassLoader();
        }

        protected ProtectionDomain getProtectionDomain() {
            return ReflectUtils.getProtectionDomain((Class)this.source);
        }

        public BaseBeanCopier create() {
            Object key = KEY_FACTORY.newInstance(this.source.getName(), this.target.getName(), this.useConverter);
            return (BaseBeanCopier)super.create(key);
        }

        public void generateClass(ClassVisitor v) {
            Type sourceType = Type.getType((Class)this.source);
            Type targetType = Type.getType((Class)this.target);
            ClassEmitter ce = new ClassEmitter(v);
            ce.begin_class(46, 1, this.getClassName(), BEAN_COPIER, null, "<generated>");
            EmitUtils.null_constructor((ClassEmitter)ce);
            CodeEmitter e = ce.begin_method(1, COPY, null);
            PropertyDescriptor[] getters = BeanUtil.getBeanGetters(this.source);
            PropertyDescriptor[] setters = BeanUtil.getBeanSetters(this.target);
            HashMap<String, PropertyDescriptor> names = new HashMap<String, PropertyDescriptor>(16);
            for (PropertyDescriptor getter : getters) {
                names.put(getter.getName(), getter);
            }
            Local targetLocal = e.make_local();
            Local sourceLocal = e.make_local();
            e.load_arg(1);
            e.checkcast(targetType);
            e.store_local(targetLocal);
            e.load_arg(0);
            e.checkcast(sourceType);
            e.store_local(sourceLocal);
            for (int i = 0; i < setters.length; ++i) {
                PropertyDescriptor setter = setters[i];
                PropertyDescriptor getter = (PropertyDescriptor)names.get(setter.getName());
                if (getter == null) continue;
                MethodInfo read = ReflectUtils.getMethodInfo((Member)getter.getReadMethod());
                MethodInfo write = ReflectUtils.getMethodInfo((Member)setter.getWriteMethod());
                if (this.useConverter) {
                    Type setterType = write.getSignature().getArgumentTypes()[0];
                    e.load_local(targetLocal);
                    e.load_arg(2);
                    e.load_local(sourceLocal);
                    e.invoke(read);
                    e.box(read.getSignature().getReturnType());
                    EmitUtils.load_class((CodeEmitter)e, (Type)setterType);
                    e.push(write.getSignature().getName());
                    e.invoke_interface(CONVERTER, CONVERT);
                    e.unbox_or_zero(setterType);
                    e.invoke(write);
                    continue;
                }
                if (!Generator.compatible(getter, setter)) continue;
                e.load_local(targetLocal);
                e.load_local(sourceLocal);
                e.invoke(read);
                e.invoke(write);
            }
            e.return_value();
            e.end_method();
            ce.end_class();
        }

        private static boolean compatible(PropertyDescriptor getter, PropertyDescriptor setter) {
            return setter.getPropertyType().isAssignableFrom(getter.getPropertyType());
        }

        protected Object firstInstance(Class type) {
            return ReflectUtils.newInstance((Class)type);
        }

        protected Object nextInstance(Object instance) {
            return instance;
        }
    }

    static interface BeanCopierKey {
        public Object newInstance(String var1, String var2, boolean var3);
    }
}

