/*
 * Decompiled with CFR 0.152.
 */
package org.violet.common.core.config.mvc;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import lombok.Generated;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.core.annotation.Order;
import org.springframework.http.converter.ByteArrayHttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.ResourceHttpMessageConverter;
import org.springframework.http.converter.ResourceRegionHttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.json.AbstractJackson2HttpMessageConverter;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.violet.common.core.config.jackson.MappingApiJackson2HttpMessageConverter;
import org.violet.common.core.config.jackson.VioletJacksonProperties;
import org.violet.common.core.util.Charsets;

@AutoConfiguration
@Order(value=-2147483648)
public class MessageConfiguration
implements WebMvcConfigurer {
    private final ObjectMapper objectMapper;
    private final VioletJacksonProperties properties;

    public void configureMessageConverters(List<HttpMessageConverter<?>> converters) {
        converters.removeIf(x -> x instanceof StringHttpMessageConverter || x instanceof AbstractJackson2HttpMessageConverter);
        converters.add((HttpMessageConverter<?>)new StringHttpMessageConverter(Charsets.UTF_8));
        converters.add((HttpMessageConverter<?>)new ByteArrayHttpMessageConverter());
        converters.add((HttpMessageConverter<?>)new ResourceHttpMessageConverter());
        converters.add((HttpMessageConverter<?>)new ResourceRegionHttpMessageConverter());
        converters.add((HttpMessageConverter<?>)new MappingApiJackson2HttpMessageConverter(this.objectMapper, this.properties));
    }

    @Generated
    public MessageConfiguration(ObjectMapper objectMapper, VioletJacksonProperties properties) {
        this.objectMapper = objectMapper;
        this.properties = properties;
    }
}

