package org.violet.common.core.util;

import cn.hutool.core.lang.id.NanoId;
import cn.hutool.core.util.StrUtil;
import lombok.extern.slf4j.Slf4j;

@Slf4j
public class ShortId {

    private static final char[] charArray = "0123456789abcdefghijkmnpqrstuvwxyz".toCharArray();
    //    private static final char[] charArray = "0123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnpqrstuvwxyz".toCharArray();
    private static final int scale = 8;


    public static String getId() {
        return NanoId.randomNanoId(null, charArray, scale);
    }

    /**
     * 使用固定前缀来生成ID
     *
     * @param prefix
     * @return
     */
    public static String getId(String prefix) {
        if (StrUtil.isNotBlank(prefix)) {
            return prefix + StrUtil.DOT + getId();

        } else {
            return getId();
        }
    }

}