package org.violet.common.core.util;

import cn.hutool.core.util.ObjectUtil;
import lombok.extern.slf4j.Slf4j;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @Author: Bridge
 * @Description: TODO
 * @Date: 2023/9/11 10:59
 **/
@Slf4j
public class PlaceholderResolver {

    private static final String STR_REGEX = "\\$\\{(.+?)\\}";

    public static String parse(String template, Map<String, String> data) {

        if (ObjectUtil.isEmpty(template)) {
            return "";
        }

        if (ObjectUtil.isEmpty(data)) {
            return template;
        }

        try {
            StringBuffer appendReplaceSb = new StringBuffer();
            Pattern pattern = Pattern.compile(STR_REGEX);
            Matcher matcher = pattern.matcher(template);
            while (matcher.find()) {
                String key = matcher.group(1).trim();
                if (data.containsKey(key)) {
                    String value = data.get(key);
                    matcher.appendReplacement(appendReplaceSb, value);
                }
            }
            matcher.appendTail(appendReplaceSb);
            return appendReplaceSb.toString();
        } catch (Exception e) {
            log.error("模板:{}解析错误,异常信息:{}",template,e.getMessage());
        }

        return template;
    }

    public static String parse(String template,String varname ,String value) {

        if (ObjectUtil.isEmpty(template)) {
            return "";
        }

        if (ObjectUtil.isEmpty(varname)) {
            return template;
        }

        try {
            StringBuffer appendReplaceSb = new StringBuffer();
            Pattern pattern = Pattern.compile(STR_REGEX);
            Matcher matcher = pattern.matcher(template);
            while (matcher.find()) {
                String key = matcher.group(1).trim();
                if(varname.equals(key)) {
                    matcher.appendReplacement(appendReplaceSb, value);
                    break;
                }
            }
            matcher.appendTail(appendReplaceSb);
            return appendReplaceSb.toString();
        } catch (Exception e) {
            log.error("模板:{}解析错误,异常信息:{}",template,e.getMessage());
        }

        return template;
    }
}
