package org.violet.common.core.util;

import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import lombok.extern.slf4j.Slf4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.violet.common.core.exception.BizException;

@Slf4j
public class CommonServletUtil {


    public CommonServletUtil() {
    }

    public static String getParamFromRequest(String paramName) {
        HttpServletRequest request = getRequest();
        String paramValue = request.getParameter(paramName);
        if (ObjectUtil.isEmpty(paramValue)) {
            paramValue = request.getHeader(paramName);
        }

        if (ObjectUtil.isEmpty(paramValue)) {
            Cookie[] cookies = request.getCookies();
            if (ObjectUtil.isNotEmpty(cookies)) {
                Cookie[] var4 = cookies;
                int var5 = cookies.length;

                for (int var6 = 0; var6 < var5; ++var6) {
                    Cookie cookie = var4[var6];
                    String cookieName = cookie.getName();
                    if (cookieName.equals(paramName)) {
                        return cookie.getValue();
                    }
                }
            }
        }

        return paramValue;
    }

    public static HttpServletRequest getRequest() {
        ServletRequestAttributes servletRequestAttributes;
        try {
            servletRequestAttributes = (ServletRequestAttributes) RequestContextHolder.getRequestAttributes();
        } catch (Exception var2) {
            log.error(">>> 非Web上下文无法获取Request：", var2);
            throw new BizException("非Web上下文无法获取Request", var2);
        }

        if (servletRequestAttributes == null) {
            throw new BizException("非Web上下文无法获取Request");
        } else {
            return servletRequestAttributes.getRequest();
        }
    }

    public static HttpServletResponse getResponse() {
        ServletRequestAttributes servletRequestAttributes;
        try {
            servletRequestAttributes = (ServletRequestAttributes) RequestContextHolder.getRequestAttributes();
        } catch (Exception var2) {
            log.error(">>> 非Web上下文无法获取Response：", var2);
            throw new BizException("非Web上下文无法获取Response", var2);
        }

        if (servletRequestAttributes == null) {
            throw new BizException("非Web上下文无法获取Response");
        } else {
            return servletRequestAttributes.getResponse();
        }
    }

    public static boolean isWeb() {
        return RequestContextHolder.getRequestAttributes() != null;
    }

}
