
package org.violet.common.core.intefaces.workflow;


import org.violet.common.core.entity.workflow.WfUser;

import java.util.List;

/**
 * 用户Api
 *
 *
 * @date 2022/6/6 11:33
 **/
public interface WfUserApi {

    /**
     * 根据用户id获取用户对象，没有则返回null
     *
     *
     * @date 2022/6/20 18:19
     **/
    WfUser getUserByIdWithoutException(String userId);

    /**
     * 根据用户id获取用户对象列表，没有的则为空，都没有则返回空集合
     *
     *
     * @date 2022/6/20 18:19
     **/
    List<WfUser> getUserListByIdListWithoutException(List<String> userIdList);

    /**
     * 根据用户id获取用户对象，没有则抛出异常
     *
     *
     * @date 2022/6/20 18:19
     **/
    WfUser getUserByIdWithException(String userId);

    /**
     * 根据组织id集合获取组织下用户id集合
     *
     *
     * @date 2022/6/6 11:40
     **/
    List<String> getUserIdListByOrgIdList(List<String> orgIdList);

    /**
     * 根据部门id集合获取部门下用户id集合
     *
     *
     * @date 2022/6/6 11:40
     **/
    List<String> getUserIdListByDeptIdList(List<String> deptIdList);

    /**
     * 根据职位id集合获取职位下用户id集合
     *
     *
     * @date 2022/6/6 11:44
     **/
    List<String> getUserIdListByPositionIdList(List<String> positionIdList);

    /**
     * 根据用户id和组织id和职位id和主管层级获取上级主管id
     *
     *
     * @date 2022/6/6 14:50
     **/
    WfUser getSupervisorIdBySupervisorLevel(List<String> userIdList, String userId, String orgId, String supervisorLevel);

    /**
     * 根据用户id和组织id和职位id和终点主管层级获取上级主管id集合
     *
     *
     * @date 2022/6/6 14:50
     **/
    List<String> getMulSupervisorIdListByEndLevel(String userId, String orgId, String endLevel);

    /**
     * 返回用户列表
     * @param orgId 组织机构ID
     * @param deptId 部门ID
     * @param searchKey 模糊查询
     * @return
     */
    List<WfUser> wfUserList(String orgId,String deptId, String searchKey);
}
