package org.violet.common.core.intefaces;

import java.util.ArrayList;
import java.util.List;

public interface ITreeNode<T extends ITreeNode> {
    /**
     * 节点ID
     *
     * @return
     */
    Object id();

    /**
     * 父节点ID
     *
     * @return
     */
    Object pid();

    /**
     * 添加子节点
     *
     * @param node
     */
    default void addChild(T node) {
        List<T> children = getChildren();
        if (children == null) {
            children = new ArrayList<T>();
        }
        children.add(node);
    }

    /**
     * 返回叶子节点的list
     *
     * @return
     */
    List<T> getChildren();
}