package org.violet.common.core.enums;

import org.violet.common.core.intefaces.IEmbedDic;

public enum GenPageType implements IEmbedDic {
    /**
     *
     */
    SINGLE_TREE_FORM("单表树型", "treeform"),

    SINGLE_TABLE("单表列表型", "tableform");


    private String text;
    /**
     * 模版文件的目录,相对于resources/gen目录
     */
    private String templateDir;

    GenPageType(String text, String templateDir) {
        this.text = text;
        this.templateDir = templateDir;
    }

    @Override
    public String text() {
        return this.text;
    }

    public String getTemplateDir() {
        return templateDir;
    }
}
