package org.violet.common.core.entity;


import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;
import org.violet.common.core.intefaces.ITreeNode;

import java.util.ArrayList;
import java.util.List;

/**
 * 菜单封装对象
 */
@Setter
@Getter
@Accessors(chain = true)
public class MenuRouterVo implements ITreeNode<MenuRouterVo> {
    /**
     * 菜单ID
     */
    private Long menuId;
    /**
     * 上级菜单ID
     */
    private Long menuPid;
    /**
     * 菜单编码
     */
    private String code;
    /**
     * 前端组件地址
     */
    private String path;
    /**
     * 菜单标题
     */
    private String title;
    /**
     * 图标
     */
    private String icon;
    /**
     * 排序
     */
    private Integer sort;

    private String link;
    /**
     * 页面打开方式
     */
    private String openType;

    private List<MenuRouterVo> children = new ArrayList<>();
    /**
     * 模块首页ID,
     */
    private Long topicPageId;

    /**
     * 绑定的界面模型
     */
    private Long relatedPageId;


    @Override
    public Object id() {
        return this.menuId;
    }

    @Override
    public Object pid() {
        return this.menuPid;
    }
}