package org.violet.common.core.embed.dict;


import org.violet.common.core.annotation.EmbedDict;
import org.violet.common.core.intefaces.IEmbedDic;

/**
 * @author fyin
 * @date 2023年07月10日 16:18
 */
@EmbedDict("数据模型列类型")
public enum DataModelColumnType implements IEmbedDic {
    /**
     * 表类型,主表,子表
     */
    ID("主键", "Long"),
    VARCHAR("字符", "String"),
    BIGINT("整数", "Long"),
    DOUBLE("浮点数", "Double"),
    DATE("日期", "Date"),
    DATETIME("时间", "Date"),
    TEXT("大文本", "String"),
    LOGIC_DELETE("逻辑删除", "Integer"),
    ;
    
    private final String text;
    
    private final String type;
    
    DataModelColumnType(String text, String type) {
        this.text = text;
        this.type = type;
    }
    
    @Override
    public String text() {
        return this.text;
    }
    
    public String type() {
        return this.type;
    }
}
