/*
 * Decompiled with CFR 0.152.
 */
package org.violet.common.core.util;

import cn.hutool.core.date.SystemClock;
import cn.hutool.core.date.TimeInterval;
import cn.hutool.core.util.IdUtil;
import java.io.PrintStream;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KindId {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KindId.class);
    private static final long OFFSET = 1577808000L;
    private static final long WORKER_ID;
    private static final long WORKER_ID_BITS = 5L;
    private static final long SEQUENCE_ID_BITS = 16L;
    private static final long WORKER_SHIFT_BITS = 16L;
    private static final long OFFSET_SHIFT_BITS = 21L;
    private static final long WORKER_ID_MAX = 15L;
    private static final long BACK_WORKER_ID_BEGIN = 16L;
    private static final long SEQUENCE_MAX = 65535L;
    private static final long BACK_TIME_MAX = 1L;
    private static long lastTimestamp;
    private static long sequence;
    private static long lastTimestampBak;
    private static long sequenceBak;

    public static long nextId() {
        return KindId.nextId(SystemClock.now() / 1000L);
    }

    private static synchronized long nextId(long timestamp) {
        if (timestamp < lastTimestamp) {
            log.warn("\u65f6\u949f\u56de\u62e8, \u542f\u7528\u5907\u4efd\u673a\u5668ID: now: [{}] last: [{}]", (Object)timestamp, (Object)lastTimestamp);
            return KindId.nextIdBackup(timestamp);
        }
        if (timestamp != lastTimestamp) {
            lastTimestamp = timestamp;
            sequence = 0L;
        }
        if (0L == (++sequence & 0xFFFFL)) {
            --sequence;
            return KindId.nextIdBackup(Math.max(timestamp, lastTimestampBak));
        }
        return timestamp - 1577808000L << 21 | WORKER_ID << 16 | sequence;
    }

    private static long nextIdBackup(long timestamp) {
        if (timestamp < lastTimestampBak) {
            if (lastTimestampBak - SystemClock.now() / 1000L > 1L) {
                throw new RuntimeException(String.format("\u65f6\u949f\u56de\u62e8: now: [%d] last: [%d]", timestamp, lastTimestampBak));
            }
            timestamp = lastTimestampBak;
        }
        if (timestamp != lastTimestampBak) {
            lastTimestampBak = timestamp;
            sequenceBak = 0L;
        }
        return 0L == (++sequenceBak & 0xFFFFL) ? KindId.nextIdBackup(timestamp + 1L) : timestamp - 1577808000L << 21 | (WORKER_ID ^ 0x10L) << 16 | sequenceBak;
    }

    public static void main(String[] args) {
        ConcurrentHashMap<Long, Integer> map = new ConcurrentHashMap<Long, Integer>();
        TimeInterval timeInterval = new TimeInterval();
        timeInterval.restart();
        for (int i = 0; i < 100000; ++i) {
            long id = KindId.nextId();
            map.put(id, String.valueOf(id).length());
        }
        PrintStream var10000 = System.out;
        int var10001 = map.size();
        var10000.println("Map after writing: " + var10001 + "  time Cost:" + timeInterval.intervalPretty());
    }

    static {
        lastTimestamp = 0L;
        sequence = 0L;
        lastTimestampBak = 0L;
        sequenceBak = 0L;
        long workerId = IdUtil.getDataCenterId((long)15L);
        if (workerId < 0L || workerId > 15L) {
            throw new IllegalArgumentException(String.format("worker-id [%d] \u8d8a\u754c, \u6709\u6548\u8303\u56f4: 0 ~ %d ", workerId, 15L));
        }
        WORKER_ID = workerId;
    }
}

