/*
 * Decompiled with CFR 0.152.
 */
package org.violet.common.core.util;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.json.JsonReadFeature;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.type.CollectionLikeType;
import com.fasterxml.jackson.databind.type.MapType;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.Nullable;
import org.violet.common.core.util.Exceptions;
import org.violet.common.core.util.ObjectUtil;
import org.violet.common.core.util.StringUtil;
import org.violet.common.core.util.VioletJavaTimeModule;

public class JsonUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JsonUtil.class);

    public static <T> String toJson(T value) {
        try {
            return JsonUtil.getInstance().writeValueAsString(value);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static byte[] toJsonAsBytes(Object object) {
        try {
            return JsonUtil.getInstance().writeValueAsBytes(object);
        }
        catch (JsonProcessingException e) {
            throw Exceptions.unchecked(e);
        }
    }

    public static <T> T parse(String content, Class<T> valueType) {
        try {
            return (T)JsonUtil.getInstance().readValue(content, valueType);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static <T> T parse(String content, TypeReference<T> typeReference) {
        try {
            return (T)JsonUtil.getInstance().readValue(content, typeReference);
        }
        catch (IOException e) {
            throw Exceptions.unchecked(e);
        }
    }

    public static <T> T parse(byte[] bytes, Class<T> valueType) {
        try {
            return (T)JsonUtil.getInstance().readValue(bytes, valueType);
        }
        catch (IOException e) {
            throw Exceptions.unchecked(e);
        }
    }

    public static <T> T parse(byte[] bytes, TypeReference<T> typeReference) {
        try {
            return (T)JsonUtil.getInstance().readValue(bytes, typeReference);
        }
        catch (IOException e) {
            throw Exceptions.unchecked(e);
        }
    }

    public static <T> T parse(InputStream in, Class<T> valueType) {
        try {
            return (T)JsonUtil.getInstance().readValue(in, valueType);
        }
        catch (IOException e) {
            throw Exceptions.unchecked(e);
        }
    }

    public static <T> T parse(InputStream in, TypeReference<T> typeReference) {
        try {
            return (T)JsonUtil.getInstance().readValue(in, typeReference);
        }
        catch (IOException e) {
            throw Exceptions.unchecked(e);
        }
    }

    public static <T> List<T> parseArray(String content, Class<T> valueTypeRef) {
        try {
            if (!StringUtil.startsWithIgnoreCase((String)content, (String)"[")) {
                content = "[" + (String)content + "]";
            }
            List list = (List)JsonUtil.getInstance().readValue((String)content, (TypeReference)new TypeReference<List<Map<String, Object>>>(){});
            ArrayList<T> result = new ArrayList<T>();
            for (Map map : list) {
                result.add(JsonUtil.toPojo(map, valueTypeRef));
            }
            return result;
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static Map<String, Object> toMap(String content) {
        try {
            return (Map)JsonUtil.getInstance().readValue(content, Map.class);
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static <T> Map<String, T> toMap(String content, Class<T> valueTypeRef) {
        try {
            Map map = (Map)JsonUtil.getInstance().readValue(content, (TypeReference)new TypeReference<Map<String, Map<String, Object>>>(){});
            HashMap<String, T> result = new HashMap<String, T>(16);
            for (Map.Entry entry : map.entrySet()) {
                result.put((String)entry.getKey(), JsonUtil.toPojo((Map)entry.getValue(), valueTypeRef));
            }
            return result;
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static <T> T toPojo(Map fromValue, Class<T> toValueType) {
        return (T)JsonUtil.getInstance().convertValue((Object)fromValue, toValueType);
    }

    public static JsonNode readTree(String jsonString) {
        try {
            return JsonUtil.getInstance().readTree(jsonString);
        }
        catch (IOException e) {
            throw Exceptions.unchecked(e);
        }
    }

    public static JsonNode readTree(InputStream in) {
        try {
            return JsonUtil.getInstance().readTree(in);
        }
        catch (IOException e) {
            throw Exceptions.unchecked(e);
        }
    }

    public static JsonNode readTree(byte[] content) {
        try {
            return JsonUtil.getInstance().readTree(content);
        }
        catch (IOException e) {
            throw Exceptions.unchecked(e);
        }
    }

    @Nullable
    public static <T> T readValue(@Nullable byte[] content, Class<T> valueType) {
        if (ObjectUtil.isEmpty((Object)content)) {
            return null;
        }
        try {
            return (T)JsonUtil.getInstance().readValue(content, valueType);
        }
        catch (IOException e) {
            throw Exceptions.unchecked(e);
        }
    }

    @Nullable
    public static <T> T readValue(@Nullable String jsonString, Class<T> valueType) {
        if (StringUtil.isBlank(jsonString)) {
            return null;
        }
        try {
            return (T)JsonUtil.getInstance().readValue(jsonString, valueType);
        }
        catch (IOException e) {
            throw Exceptions.unchecked(e);
        }
    }

    @Nullable
    public static <T> T readValue(@Nullable InputStream in, Class<T> valueType) {
        if (in == null) {
            return null;
        }
        try {
            return (T)JsonUtil.getInstance().readValue(in, valueType);
        }
        catch (IOException e) {
            throw Exceptions.unchecked(e);
        }
    }

    @Nullable
    public static <T> T readValue(@Nullable byte[] content, TypeReference<T> typeReference) {
        if (ObjectUtil.isEmpty((Object)content)) {
            return null;
        }
        try {
            return (T)JsonUtil.getInstance().readValue(content, typeReference);
        }
        catch (IOException e) {
            throw Exceptions.unchecked(e);
        }
    }

    @Nullable
    public static <T> T readValue(@Nullable String jsonString, TypeReference<T> typeReference) {
        if (StringUtil.isBlank(jsonString)) {
            return null;
        }
        try {
            return (T)JsonUtil.getInstance().readValue(jsonString, typeReference);
        }
        catch (IOException e) {
            throw Exceptions.unchecked(e);
        }
    }

    @Nullable
    public static <T> T readValue(@Nullable InputStream in, TypeReference<T> typeReference) {
        if (in == null) {
            return null;
        }
        try {
            return (T)JsonUtil.getInstance().readValue(in, typeReference);
        }
        catch (IOException e) {
            throw Exceptions.unchecked(e);
        }
    }

    public static JsonNode readTree(JsonParser jsonParser) {
        try {
            return (JsonNode)JsonUtil.getInstance().readTree(jsonParser);
        }
        catch (IOException e) {
            throw Exceptions.unchecked(e);
        }
    }

    @Nullable
    public static <T> T readValue(@Nullable byte[] content, JavaType javaType) {
        if (content == null || content.length == 0) {
            return null;
        }
        try {
            return (T)JsonUtil.getInstance().readValue(content, javaType);
        }
        catch (IOException e) {
            throw Exceptions.unchecked(e);
        }
    }

    @Nullable
    public static <T> T readValue(@Nullable String jsonString, JavaType javaType) {
        if (StringUtil.isBlank(jsonString)) {
            return null;
        }
        try {
            return (T)JsonUtil.getInstance().readValue(jsonString, javaType);
        }
        catch (IOException e) {
            throw Exceptions.unchecked(e);
        }
    }

    @Nullable
    public static <T> T readValue(@Nullable InputStream in, JavaType javaType) {
        if (in == null) {
            return null;
        }
        try {
            return (T)JsonUtil.getInstance().readValue(in, javaType);
        }
        catch (IOException e) {
            throw Exceptions.unchecked(e);
        }
    }

    @Nullable
    public static <T> T readValue(@Nullable Reader reader, JavaType javaType) {
        if (reader == null) {
            return null;
        }
        try {
            return (T)JsonUtil.getInstance().readValue(reader, javaType);
        }
        catch (IOException e) {
            throw Exceptions.unchecked(e);
        }
    }

    public static JavaType getType(Class<?> clazz) {
        return JsonUtil.getInstance().getTypeFactory().constructType(clazz);
    }

    public static MapType getMapType(Class<?> valueClass) {
        return JsonUtil.getMapType(String.class, valueClass);
    }

    public static MapType getMapType(Class<?> keyClass, Class<?> valueClass) {
        return JsonUtil.getInstance().getTypeFactory().constructMapType(Map.class, keyClass, valueClass);
    }

    public static CollectionLikeType getListType(Class<?> elementClass) {
        return JsonUtil.getInstance().getTypeFactory().constructCollectionLikeType(List.class, elementClass);
    }

    public static JavaType getParametricType(Class<?> parametrized, Class<?> ... parameterClasses) {
        return JsonUtil.getInstance().getTypeFactory().constructParametricType(parametrized, (Class[])parameterClasses);
    }

    public static JavaType getParametricType(Class<?> parametrized, JavaType ... parameterTypes) {
        return JsonUtil.getInstance().getTypeFactory().constructParametricType(parametrized, parameterTypes);
    }

    public static <T> List<T> readList(@Nullable byte[] content, Class<T> elementClass) {
        if (content == null || content.length == 0) {
            return Collections.emptyList();
        }
        try {
            return (List)JsonUtil.getInstance().readValue(content, (JavaType)JsonUtil.getListType(elementClass));
        }
        catch (IOException e) {
            throw Exceptions.unchecked(e);
        }
    }

    public static <T> List<T> readList(@Nullable InputStream content, Class<T> elementClass) {
        if (content == null) {
            return Collections.emptyList();
        }
        try {
            return (List)JsonUtil.getInstance().readValue(content, (JavaType)JsonUtil.getListType(elementClass));
        }
        catch (IOException e) {
            throw Exceptions.unchecked(e);
        }
    }

    public static <T> List<T> readList(@Nullable Reader reader, Class<T> elementClass) {
        if (reader == null) {
            return Collections.emptyList();
        }
        try {
            return (List)JsonUtil.getInstance().readValue(reader, (JavaType)JsonUtil.getListType(elementClass));
        }
        catch (IOException e) {
            throw Exceptions.unchecked(e);
        }
    }

    public static <T> List<T> readList(@Nullable String content, Class<T> elementClass) {
        if (StringUtil.isBlank(content)) {
            return Collections.emptyList();
        }
        try {
            return (List)JsonUtil.getInstance().readValue(content, (JavaType)JsonUtil.getListType(elementClass));
        }
        catch (IOException e) {
            throw Exceptions.unchecked(e);
        }
    }

    public static Map<String, Object> readMap(@Nullable byte[] content) {
        return JsonUtil.readMap(content, Object.class);
    }

    public static Map<String, Object> readMap(@Nullable InputStream content) {
        return JsonUtil.readMap(content, Object.class);
    }

    public static Map<String, Object> readMap(@Nullable Reader reader) {
        return JsonUtil.readMap(reader, Object.class);
    }

    public static Map<String, Object> readMap(@Nullable String content) {
        return JsonUtil.readMap(content, Object.class);
    }

    public static <V> Map<String, V> readMap(@Nullable byte[] content, Class<?> valueClass) {
        return JsonUtil.readMap(content, String.class, valueClass);
    }

    public static <V> Map<String, V> readMap(@Nullable InputStream content, Class<?> valueClass) {
        return JsonUtil.readMap(content, String.class, valueClass);
    }

    public static <V> Map<String, V> readMap(@Nullable Reader reader, Class<?> valueClass) {
        return JsonUtil.readMap(reader, String.class, valueClass);
    }

    public static <V> Map<String, V> readMap(@Nullable String content, Class<?> valueClass) {
        return JsonUtil.readMap(content, String.class, valueClass);
    }

    public static <K, V> Map<K, V> readMap(@Nullable byte[] content, Class<?> keyClass, Class<?> valueClass) {
        if (content == null || content.length == 0) {
            return Collections.emptyMap();
        }
        try {
            return (Map)JsonUtil.getInstance().readValue(content, (JavaType)JsonUtil.getMapType(keyClass, valueClass));
        }
        catch (IOException e) {
            throw Exceptions.unchecked(e);
        }
    }

    public static <K, V> Map<K, V> readMap(@Nullable InputStream content, Class<?> keyClass, Class<?> valueClass) {
        if (content == null) {
            return Collections.emptyMap();
        }
        try {
            return (Map)JsonUtil.getInstance().readValue(content, (JavaType)JsonUtil.getMapType(keyClass, valueClass));
        }
        catch (IOException e) {
            throw Exceptions.unchecked(e);
        }
    }

    public static <K, V> Map<K, V> readMap(@Nullable Reader reader, Class<?> keyClass, Class<?> valueClass) {
        if (reader == null) {
            return Collections.emptyMap();
        }
        try {
            return (Map)JsonUtil.getInstance().readValue(reader, (JavaType)JsonUtil.getMapType(keyClass, valueClass));
        }
        catch (IOException e) {
            throw Exceptions.unchecked(e);
        }
    }

    public static <K, V> Map<K, V> readMap(@Nullable String content, Class<?> keyClass, Class<?> valueClass) {
        if (StringUtil.isBlank(content)) {
            return Collections.emptyMap();
        }
        try {
            return (Map)JsonUtil.getInstance().readValue(content, (JavaType)JsonUtil.getMapType(keyClass, valueClass));
        }
        catch (IOException e) {
            throw Exceptions.unchecked(e);
        }
    }

    public static List<Map<String, Object>> readListMap(@Nullable String content) {
        if (ObjectUtil.isEmpty((Object)content)) {
            return Collections.emptyList();
        }
        try {
            return (List)JsonUtil.getInstance().readValue(content, (JavaType)JsonUtil.getListType(Map.class));
        }
        catch (IOException e) {
            throw Exceptions.unchecked(e);
        }
    }

    public static <T> T convertValue(Object fromValue, Class<T> toValueType) {
        return (T)JsonUtil.getInstance().convertValue(fromValue, toValueType);
    }

    public static <T> T convertValue(Object fromValue, JavaType toValueType) {
        return (T)JsonUtil.getInstance().convertValue(fromValue, toValueType);
    }

    public static <T> T convertValue(Object fromValue, TypeReference<T> toValueTypeRef) {
        return (T)JsonUtil.getInstance().convertValue(fromValue, toValueTypeRef);
    }

    public static <T> T treeToValue(TreeNode treeNode, Class<T> valueType) {
        try {
            return (T)JsonUtil.getInstance().treeToValue(treeNode, valueType);
        }
        catch (JsonProcessingException e) {
            throw Exceptions.unchecked(e);
        }
    }

    public static <T> T treeToValue(TreeNode treeNode, JavaType valueType) {
        try {
            return (T)JsonUtil.getInstance().treeToValue(treeNode, valueType);
        }
        catch (JsonProcessingException e) {
            throw Exceptions.unchecked(e);
        }
    }

    public static <T extends JsonNode> T valueToTree(@Nullable Object fromValue) {
        return (T)JsonUtil.getInstance().valueToTree(fromValue);
    }

    public static boolean canSerialize(@Nullable Object value) {
        if (value == null) {
            return true;
        }
        return JsonUtil.getInstance().canSerialize(value.getClass());
    }

    public static boolean canDeserialize(JavaType type) {
        return JsonUtil.getInstance().canDeserialize(type);
    }

    public static ObjectNode createObjectNode() {
        return JsonUtil.getInstance().createObjectNode();
    }

    public static ArrayNode createArrayNode() {
        return JsonUtil.getInstance().createArrayNode();
    }

    public static ObjectMapper getInstance() {
        return JacksonHolder.INSTANCE;
    }

    private static class JacksonHolder {
        private static final ObjectMapper INSTANCE = new JacksonObjectMapper();

        private JacksonHolder() {
        }
    }

    public static class JacksonObjectMapper
    extends ObjectMapper {
        private static final long serialVersionUID = 4288193147502386170L;
        private static final Locale CHINA = Locale.CHINA;

        public JacksonObjectMapper() {
            super.setLocale(CHINA);
            super.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
            super.setTimeZone(TimeZone.getTimeZone(ZoneId.systemDefault()));
            super.setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.CHINA));
            super.configure(JsonReadFeature.ALLOW_UNESCAPED_CONTROL_CHARS.mappedFeature(), true);
            super.configure(JsonReadFeature.ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER.mappedFeature(), true);
            super.findAndRegisterModules();
            super.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
            super.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            super.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
            super.getDeserializationConfig().withoutFeatures(new DeserializationFeature[]{DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES});
            super.registerModule((Module)new VioletJavaTimeModule());
            super.findAndRegisterModules();
        }

        public ObjectMapper copy() {
            return super.copy();
        }
    }
}

