/*
 * Decompiled with CFR 0.152.
 */
package org.violet.common.core.util;

import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.cglib.beans.BeanGenerator;
import org.springframework.cglib.beans.BeanMap;
import org.springframework.cglib.core.CodeGenerationException;
import org.springframework.util.Assert;
import org.violet.common.core.support.BaseBeanCopier;
import org.violet.common.core.support.BeanProperty;

public class BeanUtil
extends BeanUtils {
    public static <T> T newInstance(Class<?> clazz) {
        return (T)BeanUtil.instantiateClass(clazz);
    }

    public static <T> T newInstance(String clazzStr) {
        try {
            Class<?> clazz = Class.forName(clazzStr);
            return BeanUtil.newInstance(clazz);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static Object getProperty(Object bean, String propertyName) {
        Assert.notNull((Object)bean, (String)"bean Could not null");
        return BeanMap.create((Object)bean).get((Object)propertyName);
    }

    public static void setProperty(Object bean, String propertyName, Object value) {
        Assert.notNull((Object)bean, (String)"bean Could not null");
        BeanMap.create((Object)bean).put((Object)propertyName, value);
    }

    public static <T> T clone(T source) {
        return (T)BeanUtil.copy(source, source.getClass());
    }

    public static <T> T copy(Object source, Class<T> clazz) {
        BaseBeanCopier copier = BaseBeanCopier.create(source.getClass(), clazz, false);
        T to = BeanUtil.newInstance(clazz);
        copier.copy(source, to, null);
        return to;
    }

    public static void copy(Object source, Object targetBean) {
        BaseBeanCopier copier = BaseBeanCopier.create(source.getClass(), targetBean.getClass(), false);
        copier.copy(source, targetBean, null);
    }

    public static <T> T copyProperties(Object source, Class<T> target) throws BeansException {
        T to = BeanUtil.newInstance(target);
        BeanUtil.copyProperties((Object)source, to);
        return to;
    }

    public static Map<String, Object> toMap(Object bean) {
        return BeanMap.create((Object)bean);
    }

    public static <T> T toBean(Map<String, Object> beanMap, Class<T> valueType) {
        T bean = BeanUtil.newInstance(valueType);
        BeanMap.create(bean).putAll(beanMap);
        return bean;
    }

    public static Object generator(Object superBean, BeanProperty ... props) {
        Class<?> superclass = superBean.getClass();
        Object genBean = BeanUtil.generator(superclass, props);
        BeanUtil.copy(superBean, genBean);
        return genBean;
    }

    public static Object generator(Class<?> superclass, BeanProperty ... props) {
        BeanGenerator generator = new BeanGenerator();
        generator.setSuperclass(superclass);
        generator.setUseCache(true);
        for (BeanProperty prop : props) {
            generator.addProperty(prop.getName(), prop.getType());
        }
        return generator.create();
    }

    public static PropertyDescriptor[] getBeanGetters(Class type) {
        return BeanUtil.getPropertiesHelper(type, true, false);
    }

    public static PropertyDescriptor[] getBeanSetters(Class type) {
        return BeanUtil.getPropertiesHelper(type, false, true);
    }

    private static PropertyDescriptor[] getPropertiesHelper(Class type, boolean read, boolean write) {
        try {
            PropertyDescriptor[] all = BeanUtil.getPropertyDescriptors((Class)type);
            if (read && write) {
                return all;
            }
            ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>(all.length);
            for (PropertyDescriptor pd : all) {
                if (read && pd.getReadMethod() != null) {
                    properties.add(pd);
                    continue;
                }
                if (!write || pd.getWriteMethod() == null) continue;
                properties.add(pd);
            }
            return properties.toArray(new PropertyDescriptor[0]);
        }
        catch (BeansException ex) {
            throw new CodeGenerationException((Throwable)ex);
        }
    }
}

