package org.violet.common.cloud.http.restemplate;

import cn.hutool.core.util.ObjectUtil;
import jakarta.servlet.http.HttpServletRequest;
import lombok.AllArgsConstructor;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.violet.common.cloud.feign.header.VioletFeignHeadersProperties;


import java.io.IOException;
import java.util.Map;

/**
 * RestTemplateHeaderInterceptor 传递Request header
 */
@AllArgsConstructor
public class RestTemplateHeaderInterceptor implements ClientHttpRequestInterceptor {
    private final VioletFeignHeadersProperties properties;

    @Override
    public ClientHttpResponse intercept(
            HttpRequest request, byte[] bytes,
            ClientHttpRequestExecution execution) throws IOException {
        HttpHeaders httpHeaders = request.getHeaders();

        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();

        HttpServletRequest httpServletRequest = ((ServletRequestAttributes) requestAttributes).getRequest();
        if (httpServletRequest == null) {
            return execution.execute(request, bytes);
        }

        // 传递请求头
        HttpHeaders headers = request.getHeaders();
        headers.forEach((key, values) -> {
            String value = httpServletRequest.getHeader(key);
            if (ObjectUtil.isNotEmpty(value)) {
                httpHeaders.add(key, value);
            }
        });
        return execution.execute(request, bytes);
    }
}
