/*
 * Decompiled with CFR 0.152.
 */
package org.violet.common.cloud.feign.header;

import cn.hutool.core.util.ObjectUtil;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import jakarta.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.violet.common.cloud.feign.header.VioletFeignHeadersProperties;

public class VioletFeignRequestHeaderInterceptor
implements RequestInterceptor {
    private final VioletFeignHeadersProperties properties;

    public void apply(RequestTemplate template) {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (requestAttributes == null) {
            return;
        }
        HttpServletRequest request = ((ServletRequestAttributes)requestAttributes).getRequest();
        this.properties.getAllowed().forEach(headerName -> {
            String header = request.getHeader(headerName);
            if (ObjectUtil.isNotEmpty((Object)header)) {
                template.header(headerName, new String[]{header});
            }
        });
    }

    @Generated
    public VioletFeignRequestHeaderInterceptor(VioletFeignHeadersProperties properties) {
        this.properties = properties;
    }
}

