package org.violet.common.cloud.version;

import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcRegistrations;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.openfeign.AnnotatedParameterProcessor;
import org.springframework.cloud.openfeign.support.SpringMvcContract;
import org.springframework.context.annotation.Bean;
import org.springframework.core.convert.ConversionService;

import java.util.List;

/**
 * url版本号处理
 * <p>
 * 参考：https://gitee.com/lianqu1990/spring-boot-starter-version-mapping
 */
@AutoConfiguration
@ConditionalOnWebApplication
@ConditionalOnProperty(value = "violet.version.enabled", havingValue = "true")
public class VersionMappingAutoConfiguration {
    /**
     * 提供版本的url自动拼接
     *
     * @return
     */
    @Bean
    public WebMvcRegistrations violetWebMvcRegistrations() {
        return new VioletWebMvcRegistrations();
    }

    /**
     * 为feign客户端提供url自动拼接功能
     *
     * @param annotatedParameterProcessors
     * @param conversionService
     * @return
     */
    @Bean
    public SpringMvcContract violetSpringMvcContract(List<AnnotatedParameterProcessor> annotatedParameterProcessors,
                                                     ConversionService conversionService) {
        return new VioletSpringMvcContract(annotatedParameterProcessors, conversionService);
    }
}
