/*
 * Decompiled with CFR 0.152.
 */
package org.violet.common.cache.util;

import java.util.concurrent.Callable;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.lang.Nullable;
import org.violet.common.core.util.Func;
import org.violet.common.core.util.SpringUtil;

public class CacheUtil {
    public static final String SYS_CACHE = "violet:sys";
    private static CacheManager cacheManager;

    private static CacheManager getCacheManager() {
        if (cacheManager == null) {
            cacheManager = (CacheManager)SpringUtil.getBean(CacheManager.class);
        }
        return cacheManager;
    }

    public static Cache getCache(String cacheName) {
        return CacheUtil.getCacheManager().getCache(cacheName);
    }

    @Nullable
    public static Object get(String cacheName, String keyPrefix, Object key) {
        if (Func.hasEmpty((Object[])new Object[]{cacheName, keyPrefix, key})) {
            return null;
        }
        Cache.ValueWrapper wrapper = CacheUtil.getCache(cacheName).get((Object)keyPrefix.concat(String.valueOf(key)));
        return wrapper == null ? null : wrapper.get();
    }

    @Nullable
    public static <T> T get(String cacheName, String keyPrefix, Object key, @Nullable Class<T> type) {
        if (Func.hasEmpty((Object[])new Object[]{cacheName, keyPrefix, key})) {
            return null;
        }
        return (T)CacheUtil.getCache(cacheName).get((Object)keyPrefix.concat(String.valueOf(key)), type);
    }

    @Nullable
    public static <T> T get(String cacheName, String keyPrefix, Object key, Callable<T> valueLoader) {
        if (Func.hasEmpty((Object[])new Object[]{cacheName, keyPrefix, key})) {
            return null;
        }
        String cacheKey = keyPrefix.concat(String.valueOf(key));
        return (T)CacheUtil.getCache(cacheName).get((Object)cacheKey, valueLoader);
    }

    public static void put(String cacheName, String keyPrefix, Object key, @Nullable Object value) {
        CacheUtil.getCache(cacheName).put((Object)keyPrefix.concat(String.valueOf(key)), value);
    }

    public static void evict(String cacheName, String keyPrefix, Object key) {
        if (Func.hasEmpty((Object[])new Object[]{cacheName, keyPrefix, key})) {
            return;
        }
        CacheUtil.getCache(cacheName).evict((Object)keyPrefix.concat(String.valueOf(key)));
    }

    public static void clear(String cacheName) {
        if (Func.isEmpty((Object)cacheName)) {
            return;
        }
        CacheUtil.getCache(cacheName).clear();
    }
}

