/*
 * Decompiled with CFR 0.152.
 */
package org.violet.common.bootstrap.config;

import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import lombok.Generated;
import org.springframework.aop.interceptor.AsyncUncaughtExceptionHandler;
import org.springframework.aop.interceptor.SimpleAsyncUncaughtExceptionHandler;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.scheduling.annotation.AsyncConfigurerSupport;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.violet.common.bootstrap.config.VioletAsyncProperties;

@AutoConfiguration
@EnableAsync
@EnableScheduling
@EnableConfigurationProperties(value={VioletAsyncProperties.class})
public class VioletExecutorConfiguration
extends AsyncConfigurerSupport {
    private final VioletAsyncProperties violetAsyncProperties;

    @Bean(name={"ComAsyncExecutor"})
    public AsyncTaskExecutor getAsyncExecutor() {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setCorePoolSize(this.violetAsyncProperties.getCorePoolSize());
        executor.setMaxPoolSize(this.violetAsyncProperties.getMaxPoolSize());
        executor.setQueueCapacity(this.violetAsyncProperties.getQueueCapacity());
        executor.setKeepAliveSeconds(this.violetAsyncProperties.getKeepAliveSeconds());
        executor.setThreadNamePrefix("ComAsyncExecutor-");
        executor.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy());
        executor.initialize();
        return executor;
    }

    public AsyncUncaughtExceptionHandler getAsyncUncaughtExceptionHandler() {
        return new SimpleAsyncUncaughtExceptionHandler();
    }

    @Generated
    public VioletExecutorConfiguration(VioletAsyncProperties violetAsyncProperties) {
        this.violetAsyncProperties = violetAsyncProperties;
    }
}

