/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.reflectionassert;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.unitils.reflectionassert.ReflectionComparator;
import org.unitils.reflectionassert.ReflectionComparatorMode;
import org.unitils.reflectionassert.comparator.Comparator;
import org.unitils.reflectionassert.comparator.impl.CollectionComparator;
import org.unitils.reflectionassert.comparator.impl.HibernateProxyComparator;
import org.unitils.reflectionassert.comparator.impl.IgnoreDefaultsComparator;
import org.unitils.reflectionassert.comparator.impl.LenientDatesComparator;
import org.unitils.reflectionassert.comparator.impl.LenientNumberComparator;
import org.unitils.reflectionassert.comparator.impl.LenientOrderCollectionComparator;
import org.unitils.reflectionassert.comparator.impl.MapComparator;
import org.unitils.reflectionassert.comparator.impl.ObjectComparator;
import org.unitils.reflectionassert.comparator.impl.SimpleCasesComparator;
import org.unitils.util.CollectionUtils;

public class ReflectionComparatorFactory {
    protected static final Comparator LENIENT_DATES_COMPARATOR = new LenientDatesComparator();
    protected static final Comparator IGNORE_DEFAULTS_COMPARATOR = new IgnoreDefaultsComparator();
    protected static final Comparator LENIENT_NUMBER_COMPARATOR = new LenientNumberComparator();
    protected static final Comparator SIMPLE_CASES_COMPARATOR = new SimpleCasesComparator();
    protected static final Comparator LENIENT_ORDER_COMPARATOR = new LenientOrderCollectionComparator();
    protected static final Comparator COLLECTION_COMPARATOR = new CollectionComparator();
    protected static final Comparator MAP_COMPARATOR = new MapComparator();
    protected static final Comparator HIBERNATE_PROXY_COMPARATOR = new HibernateProxyComparator();
    protected static final Comparator OBJECT_COMPARATOR = new ObjectComparator();

    public static ReflectionComparator createRefectionComparator(ReflectionComparatorMode ... modes) {
        List<Comparator> comparators = ReflectionComparatorFactory.getComparatorChain(CollectionUtils.asSet(modes));
        return new ReflectionComparator(comparators);
    }

    protected static List<Comparator> getComparatorChain(Set<ReflectionComparatorMode> modes) {
        ArrayList<Comparator> comparatorChain = new ArrayList<Comparator>();
        if (modes.contains((Object)ReflectionComparatorMode.LENIENT_DATES)) {
            comparatorChain.add(LENIENT_DATES_COMPARATOR);
        }
        if (modes.contains((Object)ReflectionComparatorMode.IGNORE_DEFAULTS)) {
            comparatorChain.add(IGNORE_DEFAULTS_COMPARATOR);
        }
        comparatorChain.add(LENIENT_NUMBER_COMPARATOR);
        comparatorChain.add(SIMPLE_CASES_COMPARATOR);
        if (modes.contains((Object)ReflectionComparatorMode.LENIENT_ORDER)) {
            comparatorChain.add(LENIENT_ORDER_COMPARATOR);
        } else {
            comparatorChain.add(COLLECTION_COMPARATOR);
        }
        comparatorChain.add(MAP_COMPARATOR);
        comparatorChain.add(HIBERNATE_PROXY_COMPARATOR);
        comparatorChain.add(OBJECT_COMPARATOR);
        return comparatorChain;
    }
}

