/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitils.core.Module;
import org.unitils.core.UnitilsException;
import org.unitils.util.PropertyUtils;
import org.unitils.util.ReflectionUtils;

public class ModulesLoader {
    public static final String PROPKEY_MODULES = "unitils.modules";
    public static final String PROPKEY_MODULE_PREFIX = "unitils.module.";
    public static final String PROPKEY_MODULE_SUFFIX_ENABLED = ".enabled";
    public static final String PROPKEY_MODULE_SUFFIX_CLASS_NAME = ".className";
    public static final String PROPKEY_MODULE_SUFFIX_RUN_AFTER = ".runAfter";
    private static Log logger = LogFactory.getLog(ModulesLoader.class);

    public List<Module> loadModules(Properties configuration) {
        TreeSet<String> moduleNames = new TreeSet<String>(PropertyUtils.getStringList(PROPKEY_MODULES, configuration));
        this.removeDisabledModules(moduleNames, configuration);
        HashMap<String, List<String>> runAfters = new HashMap<String, List<String>>();
        for (String string : moduleNames) {
            List<String> runAfterModuleNames = PropertyUtils.getStringList(PROPKEY_MODULE_PREFIX + string + PROPKEY_MODULE_SUFFIX_RUN_AFTER, configuration);
            runAfters.put(string, runAfterModuleNames);
        }
        TreeMap<Integer, ArrayList<String>> runAfterCounts = new TreeMap<Integer, ArrayList<String>>();
        for (String moduleName : moduleNames) {
            int count = this.countRunAfters(moduleName, runAfters, new HashMap<String, String>());
            ArrayList<String> countModuleNames = (ArrayList<String>)runAfterCounts.get(count);
            if (countModuleNames == null) {
                countModuleNames = new ArrayList<String>();
                runAfterCounts.put(count, countModuleNames);
            }
            countModuleNames.add(moduleName);
        }
        ArrayList<Module> arrayList = new ArrayList<Module>();
        for (List moduleNameList : runAfterCounts.values()) {
            List<Module> modules = this.createAndInitializeModules(moduleNameList, configuration);
            arrayList.addAll(modules);
        }
        return arrayList;
    }

    protected List<Module> createAndInitializeModules(List<String> moduleNames, Properties configuration) {
        ArrayList<Module> result = new ArrayList<Module>();
        for (String moduleName : moduleNames) {
            String className = PropertyUtils.getString(PROPKEY_MODULE_PREFIX + moduleName + PROPKEY_MODULE_SUFFIX_CLASS_NAME, configuration);
            if (!this.classFileExistsInClasspath(className)) {
                logger.debug((Object)("Skipping module " + moduleName + ". Module class not found in classpath. Module class name: " + className));
                continue;
            }
            try {
                Object module = ReflectionUtils.createInstanceOfType(className, true);
                if (!(module instanceof Module)) {
                    throw new UnitilsException("Unable to load core. Module class is not of type UnitilsModule: " + className);
                }
                ((Module)module).init(configuration);
                result.add((Module)module);
            }
            catch (Throwable t) {
                throw new UnitilsException("An exception occured during the loading of core module " + moduleName + " with module class name " + className, t);
            }
        }
        return result;
    }

    private int countRunAfters(String moduleName, Map<String, List<String>> allRunAfters, Map<String, String> traversedModuleNames) {
        if (traversedModuleNames.containsKey(moduleName)) {
            throw new UnitilsException("Unable to load modules. Circular dependency found for modules: " + traversedModuleNames.keySet());
        }
        traversedModuleNames.put(moduleName, moduleName);
        int count = 1;
        List<String> runAfters = allRunAfters.get(moduleName);
        if (runAfters != null) {
            for (String currentModuleName : runAfters) {
                count += this.countRunAfters(currentModuleName, allRunAfters, traversedModuleNames);
            }
        }
        traversedModuleNames.remove(moduleName);
        return count;
    }

    protected void removeDisabledModules(Set<String> moduleNames, Properties configuration) {
        Iterator<String> moduleNameIterator = moduleNames.iterator();
        while (moduleNameIterator.hasNext()) {
            String moduleName = moduleNameIterator.next();
            boolean enabled = PropertyUtils.getBoolean(PROPKEY_MODULE_PREFIX + moduleName + PROPKEY_MODULE_SUFFIX_ENABLED, true, configuration);
            if (enabled) continue;
            moduleNameIterator.remove();
        }
    }

    protected boolean classFileExistsInClasspath(String className) {
        String classFileName = className.replace('.', '/') + ".class";
        return this.getClass().getClassLoader().getResource(classFileName) != null;
    }
}

