/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring3.processor.attr;

import java.util.HashMap;
import java.util.Map;
import org.thymeleaf.Arguments;
import org.thymeleaf.Configuration;
import org.thymeleaf.context.IProcessingContext;
import org.thymeleaf.dom.Element;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.standard.expression.IStandardExpression;
import org.thymeleaf.standard.expression.IStandardExpressionParser;
import org.thymeleaf.standard.expression.StandardExpressions;
import org.thymeleaf.standard.expression.VariableExpression;
import org.thymeleaf.standard.processor.attr.AbstractStandardSelectionAttrProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SpringObjectAttrProcessor
extends AbstractStandardSelectionAttrProcessor {
    public static final int ATTR_PRECEDENCE = 500;
    public static final String ATTR_NAME = "object";

    public SpringObjectAttrProcessor() {
        super(ATTR_NAME);
    }

    public int getPrecedence() {
        return 500;
    }

    protected void validateSelectionValue(Arguments arguments, Element element, String attributeName, String attributeValue, IStandardExpression expression) {
        if (expression == null || !(expression instanceof VariableExpression)) {
            throw new TemplateProcessingException("The expression used for object selection is " + expression + ", which is not valid: " + "only variable expressions (${...}) are allowed in '" + attributeName + "' attributes in " + "Spring-enabled environments.");
        }
    }

    protected Map<String, Object> getAdditionalLocalVariables(Arguments arguments, Element element, String attributeName) {
        Map previousAdditionalLocalVariables = super.getAdditionalLocalVariables(arguments, element, attributeName);
        HashMap<String, Object> additionalLocalVariables = new HashMap<String, Object>(previousAdditionalLocalVariables.size() + 3);
        additionalLocalVariables.putAll(previousAdditionalLocalVariables);
        String attributeValue = element.getAttributeValue(attributeName);
        Configuration configuration = arguments.getConfiguration();
        IStandardExpressionParser expressionParser = StandardExpressions.getExpressionParser((Configuration)configuration);
        VariableExpression varExpression = (VariableExpression)expressionParser.parseExpression(arguments.getConfiguration(), (IProcessingContext)arguments, attributeValue);
        additionalLocalVariables.put("springBoundObjectExpression", varExpression);
        additionalLocalVariables.put("springFormCommandValue", varExpression);
        return additionalLocalVariables;
    }
}

