/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wikitext.parser.preprocessor;

import de.fau.cs.osr.ptk.common.ParserState;
import org.sweble.wikitext.parser.ParserConfig;
import org.sweble.wikitext.parser.WtEntityMap;
import org.sweble.wikitext.parser.nodes.WtNode;
import org.sweble.wikitext.parser.preprocessor.WikitextPreprocessorContext;

public class WikitextPreprocessorState
extends ParserState<WikitextPreprocessorContext> {
    private ParserConfig config;
    private WtEntityMap entityMap;
    private boolean autoCorrect;
    private boolean warningsEnabled;
    private boolean gatherRtData;
    private boolean hasOnlyInclude = false;
    private boolean parseForInclusion = false;

    public WikitextPreprocessorState() {
        super(WikitextPreprocessorContext.class);
    }

    public ParserConfig getConfig() {
        return this.config;
    }

    public void init(ParserConfig config, WtEntityMap entityMap, boolean forInclusion) {
        this.config = config;
        this.entityMap = entityMap;
        this.parseForInclusion = forInclusion;
        this.autoCorrect = config.isAutoCorrect();
        this.warningsEnabled = config.isWarningsEnabled();
        this.gatherRtData = config.isGatherRtData();
    }

    public WtEntityMap getEntityMap() {
        return this.entityMap;
    }

    public boolean isAutoCorrect() {
        return this.autoCorrect;
    }

    public boolean isWarnignsEnabled() {
        return this.warningsEnabled;
    }

    public boolean isGatherRtData() {
        return this.gatherRtData;
    }

    public void setTagExtensionName(String name) {
        ((WikitextPreprocessorContext)this.getTop()).setTagExtensionName(name);
    }

    public boolean isValidClosingTag(String name) {
        String cur = ((WikitextPreprocessorContext)this.getTop()).getTagExtensionName();
        if (cur == null) {
            return false;
        }
        return name.compareToIgnoreCase(cur) == 0;
    }

    public void setTemplateBraces(int i) {
        ((WikitextPreprocessorContext)this.getTop()).setTemplateBraces(i);
    }

    public int getTemplateBraces() {
        return ((WikitextPreprocessorContext)this.getTop()).getTemplateBraces();
    }

    public boolean hasAtLeastTemplateBraces(int i) {
        return ((WikitextPreprocessorContext)this.getTop()).getTemplateBraces() >= i;
    }

    public void eatTemplateBraces(int i) {
        ((WikitextPreprocessorContext)this.getTop()).setTemplateBraces(((WikitextPreprocessorContext)this.getTop()).getTemplateBraces() - i);
    }

    public boolean isHasOnlyInclude() {
        return this.hasOnlyInclude;
    }

    public void setHasOnlyInclude(boolean hasOnlyInclude) {
        this.hasOnlyInclude = hasOnlyInclude;
    }

    public boolean isParseForInclusion() {
        return this.parseForInclusion;
    }

    public boolean isIgnoredElement(String name) {
        String lcName = name.toLowerCase();
        if (this.isParseForInclusion()) {
            return "noinclude".compareTo(lcName) == 0;
        }
        return "includeonly".compareTo(lcName) == 0;
    }

    public boolean isIgnoredTag(String name) {
        String lcName = name.toLowerCase();
        if (this.isParseForInclusion()) {
            return "includeonly".compareTo(lcName) == 0;
        }
        return "noinclude".compareTo(lcName) == 0 || "onlyinclude".compareTo(lcName) == 0;
    }

    public boolean isRedirectKeyword(String keyword) {
        return this.config.isRedirectKeyword(keyword);
    }

    public WtNode getEntity(int id) {
        return (WtNode)this.entityMap.getEntity(id);
    }
}

