/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wikitext.parser.postprocessor;

import de.fau.cs.osr.utils.visitor.VisitorLogic;
import java.util.Collection;
import java.util.ListIterator;
import org.sweble.wikitext.parser.WtRtData;
import org.sweble.wikitext.parser.nodes.WtBody;
import org.sweble.wikitext.parser.nodes.WtBold;
import org.sweble.wikitext.parser.nodes.WtDefinitionList;
import org.sweble.wikitext.parser.nodes.WtDefinitionListDef;
import org.sweble.wikitext.parser.nodes.WtDefinitionListTerm;
import org.sweble.wikitext.parser.nodes.WtExternalLink;
import org.sweble.wikitext.parser.nodes.WtHeading;
import org.sweble.wikitext.parser.nodes.WtHorizontalRule;
import org.sweble.wikitext.parser.nodes.WtImEndTag;
import org.sweble.wikitext.parser.nodes.WtImStartTag;
import org.sweble.wikitext.parser.nodes.WtImageLink;
import org.sweble.wikitext.parser.nodes.WtInternalLink;
import org.sweble.wikitext.parser.nodes.WtItalics;
import org.sweble.wikitext.parser.nodes.WtLctVarConv;
import org.sweble.wikitext.parser.nodes.WtLinkTitle;
import org.sweble.wikitext.parser.nodes.WtListItem;
import org.sweble.wikitext.parser.nodes.WtNamedXmlElement;
import org.sweble.wikitext.parser.nodes.WtNewline;
import org.sweble.wikitext.parser.nodes.WtNode;
import org.sweble.wikitext.parser.nodes.WtNodeList;
import org.sweble.wikitext.parser.nodes.WtOrderedList;
import org.sweble.wikitext.parser.nodes.WtParsedWikitextPage;
import org.sweble.wikitext.parser.nodes.WtSection;
import org.sweble.wikitext.parser.nodes.WtSemiPre;
import org.sweble.wikitext.parser.nodes.WtSemiPreLine;
import org.sweble.wikitext.parser.nodes.WtTable;
import org.sweble.wikitext.parser.nodes.WtTagExtension;
import org.sweble.wikitext.parser.nodes.WtTemplate;
import org.sweble.wikitext.parser.nodes.WtTemplateParameter;
import org.sweble.wikitext.parser.nodes.WtText;
import org.sweble.wikitext.parser.nodes.WtUnorderedList;
import org.sweble.wikitext.parser.nodes.WtUrl;
import org.sweble.wikitext.parser.nodes.WtXmlEmptyTag;
import org.sweble.wikitext.parser.nodes.WtXmlEndTag;
import org.sweble.wikitext.parser.nodes.WtXmlStartTag;
import org.sweble.wikitext.parser.postprocessor.ElementType;
import org.sweble.wikitext.parser.postprocessor.InsertionMode;
import org.sweble.wikitext.parser.postprocessor.StackScope;
import org.sweble.wikitext.parser.postprocessor.TreeBuilder;
import org.sweble.wikitext.parser.postprocessor.TreeBuilderModeBase;
import org.sweble.wikitext.parser.postprocessor.WtNodeFlags;

public final class TreeBuilderInBody
extends TreeBuilderModeBase {
    public TreeBuilderInBody(VisitorLogic<WtNode> logic, TreeBuilder treeBuilder) {
        super(logic, treeBuilder);
    }

    public void visit(WtImStartTag n) {
        switch (TreeBuilderInBody.getNodeType(n)) {
            case B: 
            case I: {
                this.startTagR28(n);
                break;
            }
            case P: {
                this.startTagR12(n);
                break;
            }
            default: {
                throw new AssertionError((Object)"Should not happen!");
            }
        }
    }

    public void visit(WtImEndTag n) {
        switch (TreeBuilderInBody.getNodeType(n)) {
            case B: 
            case I: {
                this.endTagR30(n);
                break;
            }
            case P: {
                if (!this.tb.isElementTypeInButtonScope(ElementType.P)) break;
                WtNode pEndTag = this.getFactory().createSyntheticEndTag(n);
                WtNodeFlags.setParserRecognized(pEndTag);
                this.endTagR22(pEndTag);
                break;
            }
            default: {
                throw new AssertionError((Object)"Should not happen!");
            }
        }
    }

    public void visit(WtXmlStartTag n) {
        this.handleStartTag(n);
    }

    public void visit(WtXmlEmptyTag n) {
        this.handleStartTag(n);
    }

    private void handleStartTag(WtNode n) {
        ElementType nodeType = TreeBuilderInBody.getNodeType(n);
        if (nodeType == null) {
            this.startUnknownTag(n);
            return;
        }
        switch (nodeType) {
            case P: 
            case ADDRESS: 
            case BLOCKQUOTE: 
            case CENTER: 
            case DIR: 
            case DIV: 
            case DL: 
            case MENU: 
            case OL: 
            case UL: {
                this.startTagR12(n);
                break;
            }
            case H1: 
            case H2: 
            case H3: 
            case H4: 
            case H5: 
            case H6: {
                this.startTagR13(n);
                break;
            }
            case PRE: {
                this.startTagR14(n);
                break;
            }
            case LI: {
                this.startTagR16(n);
                break;
            }
            case DD: 
            case DT: {
                this.startTagR17(n);
                break;
            }
            case B: 
            case I: 
            case BIG: 
            case CODE: 
            case EM: 
            case FONT: 
            case S: 
            case SMALL: 
            case STRIKE: 
            case STRONG: 
            case TT: 
            case U: {
                this.startTagR28(n);
                break;
            }
            case TABLE: {
                this.startTagR33(n);
                break;
            }
            case AREA: 
            case BR: {
                this.startTagR34(n);
                break;
            }
            case IMG: {
                throw new AssertionError((Object)"This must not happen!");
            }
            case HR: {
                this.startTagR37(n);
                break;
            }
            case CAPTION: 
            case TD: 
            case TH: 
            case TR: {
                this.startTagR50(n);
                break;
            }
            default: {
                if (nodeType == ElementType.UNKNOWN) {
                    this.startUnknownTag(n);
                    break;
                }
                this.startTagR51(n);
            }
        }
    }

    private void startUnknownTag(WtNode n) {
        if (n instanceof WtNamedXmlElement) {
            String name = ((WtNamedXmlElement)n).getName().toLowerCase();
            switch (this.getNonStandardElementBehavior(name)) {
                case LIKE_BR: {
                    this.startTagR34(n);
                    break;
                }
                case LIKE_DIV: {
                    this.startTagR12(n);
                    break;
                }
                case LIKE_FORMATTING: {
                    this.startTagR28(n);
                    break;
                }
                default: {
                    this.startTagR51(n);
                    break;
                }
            }
        } else {
            this.startTagR51(n);
        }
    }

    public void visit(WtXmlEndTag n) {
        ElementType nodeType = TreeBuilderInBody.getNodeType(n);
        if (nodeType == null) {
            this.endUnknownTag(n);
            return;
        }
        switch (nodeType) {
            case ADDRESS: 
            case BLOCKQUOTE: 
            case CENTER: 
            case DIR: 
            case DIV: 
            case DL: 
            case MENU: 
            case OL: 
            case UL: {
                this.endTagR20(n);
                break;
            }
            case P: {
                this.endTagR22(n);
                break;
            }
            case LI: {
                this.endTagR23(n);
                break;
            }
            case DD: 
            case DT: {
                this.endTagR24(n);
                break;
            }
            case H1: 
            case H2: 
            case H3: 
            case H4: 
            case H5: 
            case H6: {
                this.endTagR25(n);
                break;
            }
            case B: 
            case I: 
            case BIG: 
            case CODE: 
            case EM: 
            case FONT: 
            case S: 
            case SMALL: 
            case STRIKE: 
            case STRONG: 
            case TT: 
            case U: 
            case INT_LINK: 
            case EXT_LINK: 
            case URL: {
                this.endTagR30(n);
                break;
            }
            case BR: {
                this.endTagR47(n);
                break;
            }
            case FRAMED_IMG: {
                this.endTagFramedImage(n);
                break;
            }
            default: {
                if (nodeType == ElementType.UNKNOWN) {
                    this.endUnknownTag(n);
                    break;
                }
                this.endTagR52(n);
            }
        }
    }

    private void endUnknownTag(WtNode n) {
        if (n instanceof WtNamedXmlElement) {
            String name = ((WtNamedXmlElement)n).getName().toLowerCase();
            switch (this.getNonStandardElementBehavior(name)) {
                case LIKE_BR: {
                    this.endTagR47(n);
                    break;
                }
                case LIKE_DIV: {
                    this.endTagR20(n);
                    break;
                }
                case LIKE_FORMATTING: {
                    this.endTagR30(n);
                    break;
                }
                default: {
                    this.endTagR52(n);
                    break;
                }
            }
        } else {
            this.endTagR52(n);
        }
    }

    public void visit(WtNode n) {
        switch (n.getNodeType()) {
            case 458753: 
            case 720931: 
            case 720933: 
            case 720940: {
                this.tokenR01andR02(n);
                break;
            }
            case 5: 
            case 196613: 
            case 458754: 
            case 458760: 
            case 720939: {
                this.tokenR03(n);
                break;
            }
            case 720927: {
                throw new AssertionError((Object)("Node should only occur in SemiPre scope: " + n.getClass().getSimpleName()));
            }
            case 720912: 
            case 720913: 
            case 720914: 
            case 720915: {
                this.startTagR50(n);
                break;
            }
            default: {
                this.tokenR03(n);
            }
        }
    }

    public void visit(WtParsedWikitextPage n) {
        WtNode newNode = this.getFactory().createNewElement(n);
        this.tb.getStack().push(newNode);
        this.tb.setRootNode((WtParsedWikitextPage)newNode);
        this.iterate(n);
        if (!this.tb.isElementTypeInSpecificScope(StackScope.GENERAL_SCOPE_WITHOUT_LAZY_PARSED_PAGE, ElementType.PAGE)) {
            this.tb.error(n, "12.2.5.4.7 R10 (1)");
        }
        block3: for (WtNode node : this.tb.getStack()) {
            switch (TreeBuilderInBody.getNodeType(node)) {
                case P: 
                case LI: 
                case DD: 
                case DT: 
                case TABLE: 
                case TD: 
                case TH: 
                case TR: 
                case PAGE: {
                    continue block3;
                }
            }
            this.tb.error(n, "12.2.5.4.7 R10 (2)");
        }
    }

    public void visit(WtText n) {
        this.tokenR01andR02(n);
    }

    public void visit(WtNewline n) {
        this.tokenR01andR02(this.getFactory().text(n.getContent()));
    }

    public void visit(WtTemplate n) {
        this.tokenR03(n);
    }

    public void visit(WtTemplateParameter n) {
        this.tokenR03(n);
    }

    public void visit(WtTagExtension n) {
        this.tokenR03(n);
    }

    public void visit(WtHorizontalRule n) {
        this.startTagR37(n);
    }

    public void visit(WtBold n) {
        this.startTagR28(n);
        this.iterate(n);
        this.endTagR30(this.getFactory().createSyntheticEndTag(n));
    }

    public void visit(WtItalics n) {
        this.startTagR28(n);
        this.iterate(n);
        this.endTagR30(this.getFactory().createSyntheticEndTag(n));
    }

    public void visit(WtListItem n) {
        this.startTagR16(n);
        this.iterate(n);
        this.endTagR23(this.getFactory().createSyntheticEndTag(n));
    }

    public void visit(WtOrderedList n) {
        this.startTagR12(n);
        this.iterate(n);
        this.endTagR20(this.getFactory().createSyntheticEndTag(n));
    }

    public void visit(WtUnorderedList n) {
        this.startTagR12(n);
        this.iterate(n);
        this.endTagR20(this.getFactory().createSyntheticEndTag(n));
    }

    public void visit(WtDefinitionList n) {
        this.startTagR12(n);
        this.iterate(n);
        this.endTagR20(this.getFactory().createSyntheticEndTag(n));
    }

    public void visit(WtDefinitionListDef n) {
        this.startTagR17(n);
        this.iterate(n);
        this.endTagR24(this.getFactory().createSyntheticEndTag(n));
    }

    public void visit(WtDefinitionListTerm n) {
        this.startTagR17(n);
        this.iterate(n);
        this.endTagR24(this.getFactory().createSyntheticEndTag(n));
    }

    public void visit(WtInternalLink n) {
        this.startTagR27(n);
        if (n.hasTitle()) {
            this.dispatch(n.getTitle());
        }
        this.dispatch(this.getFactory().createSyntheticEndTag(n));
    }

    public void visit(WtExternalLink n) {
        this.startTagR27(n);
        if (n.hasTitle()) {
            this.dispatch(n.getTitle());
        }
        this.dispatch(this.getFactory().createSyntheticEndTag(n));
    }

    public void visit(WtUrl n) {
        this.startTagR27(n);
        this.dispatch(this.getFactory().createSyntheticEndTag(n));
    }

    public void visit(WtImageLink n) {
        if (TreeBuilder.isInlineImage(n)) {
            this.startTagR51(n);
            if (n.hasTitle()) {
                this.dispatch(n.getTitle());
            }
            this.dispatch(this.getFactory().createSyntheticEndTag(n, ElementType.INLINE_IMG));
        } else {
            this.startTagR12(n);
            if (n.hasTitle()) {
                this.dispatch(n.getTitle());
            }
            this.dispatch(this.getFactory().createSyntheticEndTag(n, ElementType.FRAMED_IMG));
        }
    }

    public void visit(WtLinkTitle n) {
        this.iterate(n);
    }

    public void visit(WtSemiPre n) {
        this.startTagR12(n);
        if (!n.isEmpty()) {
            this.iterate(n);
        }
        this.dispatch(this.getFactory().createSyntheticEndTag(n));
    }

    public void visit(WtSemiPreLine n) {
        WtRtData rtd = n.getRtd();
        this.iterateSemiPreRtdField(rtd);
        this.iterate(n);
        this.iterateSemiPreRtdField(rtd, 1);
    }

    private void iterateSemiPreRtdField(WtRtData rtd) {
        if (this.tb.getConfig().isPreserveSemiPreLeadingSpace()) {
            Object[] field = rtd.getField(0);
            int lastItem = field.length - 1;
            for (int i = 0; i <= lastItem; ++i) {
                String content;
                int lastChar;
                if (i == lastItem && field[i] instanceof String && (lastChar = (content = (String)field[i]).length() - 1) >= 0 && content.charAt(lastChar) == ' ') {
                    if (lastChar > 0) {
                        this.dispatch(this.getFactory().text(content.substring(0, lastChar)));
                    }
                    this.tb.appendToCurrentNode(this.getFactory().createSemiPreRtdNode());
                    break;
                }
                this.rtdToContent(field[i]);
            }
        } else {
            this.iterateSemiPreRtdField(rtd, 0);
        }
    }

    private void iterateSemiPreRtdField(WtRtData rtd, int index) {
        if (rtd != null) {
            for (Object o : rtd.getField(index)) {
                this.rtdToContent(o);
            }
        }
    }

    private void rtdToContent(Object o) {
        if (o instanceof WtNode) {
            this.dispatch((WtNode)o);
        } else {
            this.dispatch(this.getFactory().text(String.valueOf(o)));
        }
    }

    public void visit(WtTable n) {
        this.startTagR33(n);
        if (n.hasBody()) {
            this.iterate(n.getBody());
            this.dispatch(this.getFactory().createSyntheticEndTag(n));
        }
    }

    public void visit(WtSection n) {
        this.startTagR12(n);
        WtSection section = (WtSection)this.tb.getCurrentNode();
        if (this.visitSectionHeading(n.getHeading())) {
            if (this.tb.getCurrentNode() != section) {
                throw new AssertionError((Object)"Stack of open elements corrupted!");
            }
            boolean processedBody = false;
            if (n.hasBody() && this.visitSectionBody(n.getBody())) {
                processedBody = true;
                if (this.tb.getCurrentNode() != section) {
                    throw new AssertionError((Object)"Stack of open elements corrupted!");
                }
            }
            if (processedBody) {
                this.tb.generateImpliedEndTags();
                if (TreeBuilderInBody.getNodeType(this.tb.getCurrentNode()) != ElementType.SECTION) {
                    this.tb.error(n, "12.2.5.4.7 - R20 (2)");
                }
                this.tb.popFromStackUntilExcluding(ElementType.PAGE, ElementType.SECTION, ElementType.TABLE, ElementType.TBODY, ElementType.TFOOT, ElementType.THEAD, ElementType.TR, ElementType.TD, ElementType.TH, ElementType.CAPTION);
                if (this.tb.getCurrentNode() == section) {
                    this.tb.popFromStack();
                }
            }
        } else if (n.hasBody()) {
            this.iterate(n.getBody());
        }
    }

    public boolean visitSectionHeading(WtHeading heading) {
        if (this.tb.isElementTypeInButtonScope(ElementType.P)) {
            this.dispatch(this.getFactory().createMissingRepairEndTag(ElementType.P));
        }
        WtHeading newNode = (WtHeading)this.getFactory().createNewElement(heading);
        ((WtSection)this.tb.getCurrentNode()).setHeading(newNode);
        this.tb.getStack().push(newNode);
        this.iterate(heading);
        if (!this.tb.isInStackOfOpenElements(newNode)) {
            return false;
        }
        this.tb.generateImpliedEndTags();
        if (TreeBuilderInBody.getNodeType(this.tb.getCurrentNode()) != ElementType.SECTION_HEADING) {
            this.tb.error(heading, "12.2.5.4.7 - R20 (2)");
        }
        this.tb.popFromStackUntilExcluding(ElementType.PAGE, ElementType.SECTION_HEADING, ElementType.TABLE, ElementType.TBODY, ElementType.TFOOT, ElementType.THEAD, ElementType.TR, ElementType.TD, ElementType.TH, ElementType.CAPTION);
        if (this.tb.getCurrentNode() == newNode) {
            this.tb.popFromStack();
            return true;
        }
        return false;
    }

    public boolean visitSectionBody(WtBody body) {
        if (this.tb.isElementTypeInButtonScope(ElementType.P)) {
            this.dispatch(this.getFactory().createMissingRepairEndTag(ElementType.P));
        }
        WtBody newNode = (WtBody)this.getFactory().createNewElement(body);
        ((WtSection)this.tb.getCurrentNode()).setBody(newNode);
        this.tb.getStack().push(newNode);
        this.iterate(body);
        if (!this.tb.isInStackOfOpenElements(newNode)) {
            return false;
        }
        this.tb.generateImpliedEndTags();
        if (TreeBuilderInBody.getNodeType(this.tb.getCurrentNode()) != ElementType.SECTION_BODY) {
            this.tb.error(body, "12.2.5.4.7 - R20 (2)");
        }
        this.tb.popFromStackUntilExcluding(ElementType.PAGE, ElementType.SECTION_BODY, ElementType.TABLE, ElementType.TBODY, ElementType.TFOOT, ElementType.THEAD, ElementType.TR, ElementType.TD, ElementType.TH, ElementType.CAPTION);
        if (this.tb.getCurrentNode() == newNode) {
            this.tb.popFromStack();
            return true;
        }
        return false;
    }

    public void visit(WtLctVarConv n) {
        this.startTagR28(n);
        this.iterate(n.getText());
        this.endTagR30(this.getFactory().createSyntheticEndTag(n));
    }

    private void tokenR01andR02(WtText text) {
        this.tb.reconstructActiveFormattingElements();
        this.tb.insertText(text);
    }

    private void tokenR01andR02(WtNode n) {
        this.tb.reconstructActiveFormattingElements();
        this.tb.appendToCurrentNode(n);
    }

    private void tokenR03(WtNode n) {
        this.tb.appendToCurrentNode(n);
    }

    private void startTagR12(WtNode n) {
        if (this.tb.isElementTypeInButtonScope(ElementType.P)) {
            this.dispatch(this.getFactory().createMissingRepairEndTag(ElementType.P));
        }
        this.tb.insertAnHtmlElement(n);
    }

    private void startTagR13(WtNode n) {
        if (this.tb.isElementTypeInButtonScope(ElementType.P)) {
            this.dispatch(this.getFactory().createMissingRepairEndTag(ElementType.P));
        }
        if (this.tb.isCurrentNodeTypeOneOf(ElementType.H1, ElementType.H2, ElementType.H3, ElementType.H4, ElementType.H5, ElementType.H6)) {
            this.tb.error(n, "12.2.5.4.7 - R13");
            this.tb.popFromStack();
        }
        this.tb.insertAnHtmlElement(n);
    }

    private void startTagR14(WtNode n) {
        if (this.tb.isElementTypeInButtonScope(ElementType.P)) {
            this.dispatch(this.getFactory().createMissingRepairEndTag(ElementType.P));
        }
        this.tb.insertAnHtmlElement(n);
    }

    private void startTagR16(WtNode n) {
        for (WtNode node : this.tb.getStack()) {
            ElementType nodeType = TreeBuilderInBody.getNodeType(node);
            if (nodeType == ElementType.LI) {
                this.dispatch(this.getFactory().createMissingRepairEndTag(ElementType.LI));
                break;
            }
            if (!nodeType.isSpecial() || TreeBuilderInBody.isTypeOneOf(nodeType, ElementType.ADDRESS, ElementType.DIV, ElementType.P)) continue;
            break;
        }
        if (this.tb.isElementTypeInButtonScope(ElementType.P)) {
            this.dispatch(this.getFactory().createMissingRepairEndTag(ElementType.P));
        }
        this.tb.insertAnHtmlElement(n);
    }

    private void startTagR17(WtNode n) {
        for (WtNode node : this.tb.getStack()) {
            ElementType nodeType = TreeBuilderInBody.getNodeType(node);
            if (TreeBuilderInBody.isTypeOneOf(nodeType, ElementType.DD, ElementType.DT)) {
                this.dispatch(this.getFactory().createMissingRepairEndTag(nodeType));
                break;
            }
            if (!nodeType.isSpecial() || TreeBuilderInBody.isTypeOneOf(nodeType, ElementType.ADDRESS, ElementType.DIV, ElementType.P)) continue;
            break;
        }
        if (this.tb.isElementTypeInButtonScope(ElementType.P)) {
            this.dispatch(this.getFactory().createMissingRepairEndTag(ElementType.P));
        }
        this.tb.insertAnHtmlElement(n);
    }

    private void endTagR20(WtNode n) {
        ElementType elementType = TreeBuilderInBody.getNodeType(n);
        if (elementType == ElementType.UNKNOWN) {
            this.unknownEndTagR20(n);
        } else if (!this.tb.isElementTypeInScope(elementType)) {
            this.tb.error(n, "12.2.5.4.7 - R20 (1)");
            this.tb.ignore(n);
        } else {
            this.tb.generateImpliedEndTags();
            if (TreeBuilderInBody.getNodeType(this.tb.getCurrentNode()) != elementType) {
                this.tb.error(n, "12.2.5.4.7 - R20 (2)");
            }
            TreeBuilderInBody.addRtDataOfEndTag(this.tb.popFromStackUntilIncluding(elementType), n);
        }
    }

    private void unknownEndTagR20(WtNode n) {
        if (!this.tb.isNodeInSpecificScope(StackScope.GENERAL_SCOPE, n)) {
            this.tb.error(n, "12.2.5.4.7 - R20 (1)");
            this.tb.ignore(n);
        } else {
            this.tb.generateImpliedEndTags();
            if (!TreeBuilder.isSameTag(this.tb.getCurrentNode(), n)) {
                this.tb.error(n, "12.2.5.4.7 - R20 (2)");
            }
            TreeBuilderInBody.addRtDataOfEndTag(this.tb.popFromStackUntilIncluding(n), n);
        }
    }

    private void endTagR22(WtNode n) {
        if (!this.tb.isElementTypeInButtonScope(ElementType.P)) {
            this.tb.error(n, "12.2.5.4.7 - R22 (1)");
            this.dispatch(this.getFactory().createMissingRepairStartTag(ElementType.P));
            this.dispatch(n);
        } else {
            WtNode t;
            int last;
            this.tb.generateImpliedEndTags(ElementType.P);
            if (TreeBuilderInBody.getNodeType(this.tb.getCurrentNode()) != ElementType.P) {
                this.tb.error(n, "12.2.5.4.7 - R22 (2)");
            }
            WtNode p = this.tb.popFromStackUntilIncluding(ElementType.P);
            TreeBuilderInBody.addRtDataOfEndTag(p, n);
            if (!WtNodeFlags.isParserRecognized(n) && (last = p.size() - 1) > 0 && (t = (WtNode)p.get(last)).getNodeType() == 4097) {
                WtText tn = (WtText)t;
                String text = tn.getContent();
                int count = 0;
                int lastNewline = -1;
                block4: for (int j = text.length() - 1; j >= 0; --j) {
                    char ch = text.charAt(j);
                    switch (ch) {
                        case '\t': 
                        case ' ': {
                            continue block4;
                        }
                        case '\n': {
                            if (++count > 2) continue block4;
                            lastNewline = j;
                            continue block4;
                        }
                    }
                }
                if (count > 0) {
                    String outerNewlines;
                    if (lastNewline > 0) {
                        tn.setContent(text.substring(0, lastNewline));
                        outerNewlines = text.substring(lastNewline);
                    } else {
                        p.remove(last);
                        outerNewlines = text;
                    }
                    this.tokenR01andR02(this.getFactory().text(outerNewlines));
                }
            }
        }
    }

    private void endTagR23(WtNode n) {
        if (!this.tb.isElementTypeInListScope(ElementType.LI)) {
            this.tb.error(n, "12.2.5.4.7 - R23 (1)");
            this.tb.ignore(n);
        } else {
            this.tb.generateImpliedEndTags(ElementType.LI);
            if (TreeBuilderInBody.getNodeType(this.tb.getCurrentNode()) != ElementType.LI) {
                this.tb.error(n, "12.2.5.4.7 - R23 (2)");
            }
            TreeBuilderInBody.addRtDataOfEndTag(this.tb.popFromStackUntilIncluding(ElementType.LI), n);
        }
    }

    private void endTagR24(WtNode n) {
        ElementType nodeType = TreeBuilderInBody.getNodeType(n);
        if (!this.tb.isElementTypeInScope(nodeType)) {
            this.tb.error(n, "12.2.5.4.7 - R24 (1)");
            this.tb.ignore(n);
        } else {
            this.tb.generateImpliedEndTags(nodeType);
            if (TreeBuilderInBody.getNodeType(this.tb.getCurrentNode()) != nodeType) {
                this.tb.error(n, "12.2.5.4.7 - R24 (2)");
            }
            TreeBuilderInBody.addRtDataOfEndTag(this.tb.popFromStackUntilIncluding(nodeType), n);
        }
    }

    private void endTagFramedImage(WtNode n) {
        ElementType nodeType = TreeBuilderInBody.getNodeType(n);
        if (!this.tb.isElementTypeInScope(nodeType)) {
            this.tb.error(n, "12.2.5.4.7 - R24 (1)");
            this.tb.ignore(n);
        } else {
            this.tb.generateImpliedEndTags(nodeType);
            if (TreeBuilderInBody.getNodeType(this.tb.getCurrentNode()) != nodeType) {
                this.tb.error(n, "12.2.5.4.7 - R24 (2)");
            }
            TreeBuilderInBody.addRtDataOfEndTag(this.tb.popFromStackUntilIncluding(nodeType), n);
        }
    }

    private void endTagR25(WtNode n) {
        if (!this.tb.isOneOfElementTypesInScope(ElementType.H1, ElementType.H2, ElementType.H3, ElementType.H4, ElementType.H5, ElementType.H6)) {
            this.tb.error(n, "12.2.5.4.7 - R25 (1)");
            this.tb.ignore(n);
        } else {
            this.tb.generateImpliedEndTags();
            if (TreeBuilderInBody.getNodeType(this.tb.getCurrentNode()) != TreeBuilderInBody.getNodeType(n)) {
                this.tb.error(n, "12.2.5.4.7 - R25 (2)");
            }
            TreeBuilderInBody.addRtDataOfEndTag(this.tb.popFromStackUntilIncluding(ElementType.H1, ElementType.H2, ElementType.H3, ElementType.H4, ElementType.H5, ElementType.H6), n);
        }
    }

    private void startTagR27(WtNode n) {
        if (this.forceCloseLink(n, ElementType.INT_LINK) || this.forceCloseLink(n, ElementType.EXT_LINK) || this.forceCloseLink(n, ElementType.URL)) {
            // empty if block
        }
        this.tb.reconstructActiveFormattingElements();
        WtNode a = this.tb.insertAnHtmlElement(n);
        this.tb.pushActiveFormattingElements(a);
    }

    private boolean forceCloseLink(WtNode n, ElementType type) {
        WtNode active = this.tb.getActiveFormattingElement(type);
        if (active != null) {
            this.tb.error(n, "12.2.5.4.7 - R27");
            this.dispatch(this.getFactory().createMissingRepairEndTag(type));
            if (this.tb.isInStackOfOpenElements(active)) {
                this.tb.removeFromStack(active);
            }
            if (this.tb.isInListOfActiveFormattingElements(active)) {
                this.tb.removeFromActiveFormattingElements(active);
            }
            return true;
        }
        return false;
    }

    private void startTagR28(WtNode n) {
        this.tb.reconstructActiveFormattingElements();
        WtNode e = this.tb.insertAnHtmlElement(n);
        this.tb.pushActiveFormattingElements(e);
    }

    private void endTagR30(WtNode n) {
        ElementType nodeType = TreeBuilderInBody.getNodeType(n);
        int i = 0;
        while (i < 8) {
            ++i;
            WtNode fe = this.tb.getActiveFormattingElement(nodeType);
            if (fe == null) {
                this.endTagR52(n);
                return;
            }
            if (!this.tb.isInStackOfOpenElements(fe)) {
                this.tb.error(n, "12.2.5.4.7 - R30 (1)");
                this.tb.removeFromActiveFormattingElements(fe);
                this.tb.ignore(n);
                return;
            }
            if (!this.tb.isNodeRefInScope(fe)) {
                this.tb.error(n, "12.2.5.4.7 - R30 (2)");
                this.tb.ignore(n);
                return;
            }
            if (this.tb.getCurrentNode() != fe) {
                this.tb.error(n, "12.2.5.4.7 - R30 (3)");
            }
            ListIterator<WtNode> stackIter = this.tb.getStack().listIterator();
            WtNode commonAncestor = null;
            while (stackIter.hasNext()) {
                WtNode e = (WtNode)stackIter.next();
                if (e != fe) continue;
                commonAncestor = (WtNode)stackIter.next();
                stackIter.previous();
                stackIter.previous();
                break;
            }
            if (commonAncestor == null) {
                throw new AssertionError();
            }
            WtNode furthestBlock = null;
            WtNode furthestBlockParent = fe;
            while (stackIter.hasPrevious()) {
                WtNode e = (WtNode)stackIter.previous();
                if (TreeBuilderInBody.getNodeType(e).isSpecial()) {
                    furthestBlock = e;
                    break;
                }
                furthestBlockParent = e;
            }
            if (furthestBlock == null) {
                this.tb.popFromStackUntilIncludingRef(fe);
                TreeBuilderInBody.addRtDataOfEndTag(fe, n);
                this.tb.removeFromActiveFormattingElements(fe);
                return;
            }
            this.tb.placeBookmarkAfter(fe);
            stackIter.next();
            WtNode node = furthestBlock;
            WtNode lastNode = furthestBlock;
            WtNode lastNodeParent = furthestBlockParent;
            int j = 0;
            while (j < 3) {
                ++j;
                node = (WtNode)stackIter.next();
                if (!this.tb.isInListOfActiveFormattingElements(node)) {
                    stackIter.remove();
                    continue;
                }
                if (node == fe) break;
                WtNode replacement = this.getFactory().createRepairFormattingElement(node);
                this.tb.replaceInListOfActiveFormattingElements(node, replacement);
                stackIter.set(replacement);
                node = replacement;
                if (lastNode == furthestBlock) {
                    this.tb.moveBookmarkAfter(replacement);
                }
                if (lastNodeParent != null) {
                    this.tb.removeFromParent(lastNode, lastNodeParent);
                }
                this.tb.getContentOfNodeForModification(node).add(lastNode);
                lastNode = node;
                lastNodeParent = null;
            }
            if (TreeBuilderInBody.isNodeOneOf(commonAncestor, ElementType.TABLE, ElementType.TBODY, ElementType.TFOOT, ElementType.THEAD, ElementType.TR)) {
                if (lastNodeParent != null) {
                    this.tb.removeFromParent(lastNode, lastNodeParent);
                }
                this.tb.insertInFosterParent(lastNode);
            } else {
                if (lastNodeParent != null) {
                    this.tb.removeFromParent(lastNode, lastNodeParent);
                }
                this.tb.getContentOfNodeForModification(commonAncestor).add(lastNode);
            }
            WtNode adopter = this.getFactory().createAdopterElement(fe);
            WtNodeList contentOfFb = this.tb.getContentOfNodeForModification(furthestBlock);
            this.tb.getContentOfNodeForModification(adopter).addAll((Collection)((Object)contentOfFb));
            contentOfFb.clear();
            contentOfFb.add(adopter);
            this.tb.replaceBookmarkWithAndRemove(adopter, fe);
            this.tb.removeFromStack(fe);
            this.tb.insertOnStackBelow(furthestBlock, adopter);
        }
    }

    private void startTagR33(WtNode n) {
        if (this.tb.isElementTypeInButtonScope(ElementType.P)) {
            this.dispatch(this.getFactory().createMissingRepairEndTag(ElementType.P));
        }
        this.tb.insertAnHtmlElement(n);
        this.tb.switchInsertionMode(InsertionMode.IN_TABLE);
    }

    private void startTagR34(WtNode n) {
        this.tb.reconstructActiveFormattingElements();
        this.tb.insertAnHtmlElement(n);
        this.tb.popFromStack();
    }

    private void startTagR37(WtNode n) {
        if (this.tb.isElementTypeInButtonScope(ElementType.P)) {
            this.dispatch(this.getFactory().createMissingRepairEndTag(ElementType.P));
        }
        this.tb.insertAnHtmlElement(n);
        this.tb.popFromStack();
    }

    private void endTagR47(WtNode n) {
        this.tb.error(n, "12.2.5.4.7 - R47");
        this.handleStartTag(this.getFactory().createElementRepair(n));
    }

    private void startTagR50(WtNode n) {
        this.tb.error(n, "12.2.5.4.7 - R50");
        this.tb.ignore(n);
    }

    private void startTagR51(WtNode n) {
        this.tb.reconstructActiveFormattingElements();
        this.tb.insertAnHtmlElement(n);
        if (n.getNodeType() == 720935) {
            this.tb.popFromStack();
        }
    }

    private void endTagR52(WtNode n) {
        for (WtNode node : this.tb.getStack()) {
            if (TreeBuilder.isSameTag(node, n)) {
                this.tb.generateImpliedEndTags(n);
                if (!TreeBuilder.isSameTag(this.tb.getCurrentNode(), n)) {
                    this.tb.error(n, "12.2.5.4.7 - R52 (1)");
                }
                this.tb.popFromStackUntilIncludingRef(node);
                TreeBuilderInBody.addRtDataOfEndTag(node, n);
                return;
            }
            if (!TreeBuilderInBody.getNodeType(node).isSpecial()) continue;
            this.tb.error(n, "12.2.5.4.7 - R52 (2)");
            this.tb.ignore(n);
            return;
        }
    }
}

