/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wikitext.parser.postprocessor;

import de.fau.cs.osr.ptk.common.AstVisitor;
import de.fau.cs.osr.ptk.common.Warning;
import de.fau.cs.osr.utils.StringTools;
import de.fau.cs.osr.utils.visitor.VisitorInterface;
import de.fau.cs.osr.utils.visitor.VisitorLogic;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import org.sweble.wikitext.parser.ParserConfig;
import org.sweble.wikitext.parser.WtRtData;
import org.sweble.wikitext.parser.comparer.WtComparer;
import org.sweble.wikitext.parser.nodes.WikitextNodeFactory;
import org.sweble.wikitext.parser.nodes.WtBody;
import org.sweble.wikitext.parser.nodes.WtContentNode;
import org.sweble.wikitext.parser.nodes.WtExternalLink;
import org.sweble.wikitext.parser.nodes.WtImEndTag;
import org.sweble.wikitext.parser.nodes.WtImStartTag;
import org.sweble.wikitext.parser.nodes.WtImageLink;
import org.sweble.wikitext.parser.nodes.WtInternalLink;
import org.sweble.wikitext.parser.nodes.WtLctVarConv;
import org.sweble.wikitext.parser.nodes.WtLeafNode;
import org.sweble.wikitext.parser.nodes.WtLinkTitle;
import org.sweble.wikitext.parser.nodes.WtNamedXmlElement;
import org.sweble.wikitext.parser.nodes.WtNode;
import org.sweble.wikitext.parser.nodes.WtNodeList;
import org.sweble.wikitext.parser.nodes.WtParsedWikitextPage;
import org.sweble.wikitext.parser.nodes.WtTable;
import org.sweble.wikitext.parser.nodes.WtTableCaption;
import org.sweble.wikitext.parser.nodes.WtTableCell;
import org.sweble.wikitext.parser.nodes.WtTableHeader;
import org.sweble.wikitext.parser.nodes.WtTableImplicitTableBody;
import org.sweble.wikitext.parser.nodes.WtTableRow;
import org.sweble.wikitext.parser.nodes.WtText;
import org.sweble.wikitext.parser.nodes.WtValue;
import org.sweble.wikitext.parser.nodes.WtXmlAttribute;
import org.sweble.wikitext.parser.nodes.WtXmlAttributes;
import org.sweble.wikitext.parser.nodes.WtXmlElement;
import org.sweble.wikitext.parser.postprocessor.ElementFactory;
import org.sweble.wikitext.parser.postprocessor.ElementType;
import org.sweble.wikitext.parser.postprocessor.InsertionMode;
import org.sweble.wikitext.parser.postprocessor.StackScope;
import org.sweble.wikitext.parser.postprocessor.TreeBuilderInBody;
import org.sweble.wikitext.parser.postprocessor.TreeBuilderInTable;
import org.sweble.wikitext.parser.postprocessor.TreeBuilderModeBase;
import org.sweble.wikitext.parser.postprocessor.TreeBuilderWarning;
import org.sweble.wikitext.parser.postprocessor.WtNodeFlags;
import org.sweble.wikitext.parser.utils.WtRtDataPrinter;

public class TreeBuilder {
    static final boolean DEBUG = false;
    private static final WtNode MARKER = null;
    private static final WtNode BOOKMARK = new Bookmark();
    private final VisitorLogic<WtNode> logic = new VisitorLogic(null);
    private final AstVisitor<WtNode> inBodyMode = new TreeBuilderInBody(this.logic, this);
    private final AstVisitor<WtNode> inTableMode = new TreeBuilderInTable(this.logic, this);
    private final AstVisitor<WtNode> inTableTextMode = new TreeBuilderInTable.TreeBuilderInTableText(this.logic, this);
    private final AstVisitor<WtNode> inCaptionMode = new TreeBuilderInTable.TreeBuilderInCaption(this.logic, this);
    private final AstVisitor<WtNode> inColumnGroupMode = new TreeBuilderInTable.TreeBuilderInColumnGroup(this.logic, this);
    private final AstVisitor<WtNode> inTableBodyMode = new TreeBuilderInTable.TreeBuilderInTableBody(this.logic, this);
    private final AstVisitor<WtNode> inRowMode = new TreeBuilderInTable.TreeBuilderInRow(this.logic, this);
    private final AstVisitor<WtNode> inCellMode = new TreeBuilderInTable.TreeBuilderInCell(this.logic, this);
    private final LinkedList<WtNode> stack = new LinkedList();
    private final LinkedList<WtNode> activeFormattingElements = new LinkedList();
    private final LinkedList<Warning> errors = new LinkedList();
    private final ElementFactory factory;
    private final ParserConfig config;
    private WtParsedWikitextPage rootNode = null;
    private WtNode formPointer = null;
    private VisitorInterface<WtNode> originalInsertionMode;
    private String pendingTableCharTokens = null;
    private boolean fosterParentingMode = false;
    private final WikitextNodeFactory nf;
    private int dbgIndent = 0;

    public static WtParsedWikitextPage process(ParserConfig config, WtNode ast) {
        return new TreeBuilder(config).go(ast);
    }

    public TreeBuilder(ParserConfig config) {
        this.config = config;
        this.factory = new ElementFactory(this);
        this.nf = this.getConfig().getNodeFactory();
    }

    void dbgIn(String format, Object ... args) {
        System.out.println(StringTools.indent((String)String.format(format, args), (String)StringTools.strrep((char)' ', (int)(this.dbgIndent * 4))));
        ++this.dbgIndent;
    }

    void dbg(String format, Object ... args) {
        System.out.println(StringTools.indent((String)String.format(format, args), (String)StringTools.strrep((char)' ', (int)(this.dbgIndent * 4))));
    }

    void dbgOut(String format, Object ... args) {
        --this.dbgIndent;
        System.out.println(StringTools.indent((String)String.format(format, args), (String)StringTools.strrep((char)' ', (int)(this.dbgIndent * 4))));
    }

    private WtParsedWikitextPage go(WtNode ast) {
        this.switchInsertionMode(InsertionMode.IN_BODY);
        this.logic.go((Object)ast);
        if (this.getRootNode() == null) {
            throw new AssertionError((Object)"No root node set after processing!");
        }
        if (!this.errors.isEmpty()) {
            if (this.getRootNode().getWarnings().isEmpty()) {
                this.getRootNode().setWarnings(this.errors);
            } else {
                this.getRootNode().getWarnings().addAll(this.errors);
            }
        }
        return this.getRootNode();
    }

    void processInInsertionMode(InsertionMode mode, WtNode n) {
        VisitorLogic.dispatchTo(this.getModeImpl(mode), (Object)n);
    }

    void switchInsertionMode(InsertionMode mode) {
        this.logic.setImpl(this.getModeImpl(mode));
    }

    VisitorInterface<WtNode> getModeImpl(InsertionMode mode) {
        switch (mode) {
            case IN_BODY: {
                return this.inBodyMode;
            }
            case IN_TABLE: {
                return this.inTableMode;
            }
            case IN_CAPTION: {
                return this.inCaptionMode;
            }
            case IN_CELL: {
                return this.inCellMode;
            }
            case IN_COLUMN_GROUP: {
                return this.inColumnGroupMode;
            }
            case IN_ROW: {
                return this.inRowMode;
            }
            case IN_TABLE_BODY: {
                return this.inTableBodyMode;
            }
            case IN_TABLE_TEXT: {
                return this.inTableTextMode;
            }
        }
        throw new AssertionError();
    }

    void setOriginalInsertionMode() {
        this.originalInsertionMode = this.logic.getImpl();
    }

    void resetToOriginalInsertionMode() {
        this.logic.setImpl(this.originalInsertionMode);
    }

    void resetInsertionMode() {
        for (WtNode node : this.stack) {
            switch (TreeBuilder.getNodeType(node)) {
                case TD: 
                case TH: {
                    this.switchInsertionMode(InsertionMode.IN_CELL);
                    return;
                }
                case TR: {
                    this.switchInsertionMode(InsertionMode.IN_ROW);
                    return;
                }
                case TBODY: 
                case THEAD: 
                case TFOOT: {
                    this.switchInsertionMode(InsertionMode.IN_TABLE_BODY);
                    return;
                }
                case CAPTION: {
                    this.switchInsertionMode(InsertionMode.IN_CAPTION);
                    return;
                }
                case TABLE: {
                    this.switchInsertionMode(InsertionMode.IN_TABLE);
                    return;
                }
                case PAGE: {
                    this.switchInsertionMode(InsertionMode.IN_BODY);
                    return;
                }
            }
        }
    }

    ParserConfig getConfig() {
        return this.config;
    }

    ElementFactory getFactory() {
        return this.factory;
    }

    WtParsedWikitextPage getRootNode() {
        return this.rootNode;
    }

    void setRootNode(WtParsedWikitextPage rootNode) {
        this.rootNode = rootNode;
    }

    LinkedList<WtNode> getStack() {
        return this.stack;
    }

    WtNode getFormPointer() {
        return this.formPointer;
    }

    void setFormPointer(WtNode formPointer) {
        this.formPointer = formPointer;
    }

    void resetPendingTableCharTokens() {
        this.pendingTableCharTokens = "";
    }

    void appendToPendingTableCharTokens(String content) {
        this.pendingTableCharTokens = this.pendingTableCharTokens + content;
    }

    String getPendingTableCharTokens() {
        String text = this.pendingTableCharTokens;
        this.pendingTableCharTokens = null;
        return text;
    }

    WtNodeList getContentOfNode(WtNode node) {
        if (node instanceof WtNodeList) {
            return (WtNodeList)node;
        }
        switch (node.getNodeType()) {
            case 720902: {
                return ((WtInternalLink)node).getTitle();
            }
            case 720901: {
                return ((WtExternalLink)node).getTitle();
            }
            case 720903: {
                return ((WtImageLink)node).getTitle();
            }
            case 720932: {
                return ((WtXmlElement)node).getBody();
            }
            case 720911: {
                return ((WtTable)node).getBody();
            }
            case 720946: {
                return ((WtTableImplicitTableBody)node).getBody();
            }
            case 720912: {
                return ((WtTableCaption)node).getBody();
            }
            case 720913: {
                return ((WtTableRow)node).getBody();
            }
            case 720915: {
                return ((WtTableHeader)node).getBody();
            }
            case 720914: {
                return ((WtTableCell)node).getBody();
            }
            case 720950: {
                return ((WtLctVarConv)node).getText();
            }
        }
        throw new AssertionError();
    }

    WtNodeList getContentOfNodeForModification(WtNode node) {
        WtNodeList content = this.getContentOfNode(node);
        if (content instanceof WtContentNode.WtAbsentContentNode) {
            WtNodeList originalContent = content;
            switch (node.getNodeType()) {
                case 720902: {
                    content = this.nf.linkTitle(this.nf.list());
                    ((WtInternalLink)node).setTitle((WtLinkTitle)content);
                    break;
                }
                case 720901: {
                    content = this.nf.linkTitle(this.nf.list());
                    ((WtExternalLink)node).setTitle((WtLinkTitle)content);
                    break;
                }
                case 720903: {
                    content = this.nf.linkTitle(this.nf.list());
                    ((WtImageLink)node).setTitle((WtLinkTitle)content);
                    break;
                }
                case 720932: {
                    content = this.nf.body(this.nf.list());
                    ((WtXmlElement)node).setBody((WtBody)content);
                    break;
                }
                case 720911: {
                    content = this.nf.body(this.nf.list());
                    ((WtTable)node).setBody((WtBody)content);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            content.setRtd(originalContent.getRtd());
        }
        return content;
    }

    static boolean isNodeTypeOneOf(WtNode node, ElementType ... types) {
        return TreeBuilder.isTypeOneOf(TreeBuilder.getNodeType(node), types);
    }

    static ElementType getNodeType(WtNode node) {
        ElementType nodeType = ElementType.getType(node);
        return nodeType;
    }

    static boolean isTypeOneOf(ElementType nodeType, ElementType ... types) {
        for (ElementType type : types) {
            if (type != nodeType) continue;
            return true;
        }
        return false;
    }

    static boolean isSameFormattingElement(WtNode e0, WtNode e1) {
        WtXmlAttributes a1;
        ElementType t1;
        if (e0 == e1) {
            return true;
        }
        ElementType t0 = TreeBuilder.getNodeType(e0);
        if (t0 != (t1 = TreeBuilder.getNodeType(e1))) {
            return false;
        }
        if (e0.getNodeType() == 720932) {
            WtXmlAttributes a0 = ((WtXmlElement)e0).getXmlAttributes();
            if (e1.getNodeType() == 720932) {
                return TreeBuilder.isSameAttributes(a0, ((WtXmlElement)e1).getXmlAttributes());
            }
            if (a0 != null && !a0.isEmpty()) {
                return false;
            }
        } else if (e1.getNodeType() == 720932 && (a1 = ((WtXmlElement)e1).getXmlAttributes()) != null && !a1.isEmpty()) {
            return false;
        }
        return true;
    }

    static boolean isSameAttributes(WtNodeList a0, WtNodeList a1) {
        WtXmlAttribute a;
        WtNode n;
        if (a0 == a1) {
            return true;
        }
        HashMap<String, WtValue> m0 = new HashMap<String, WtValue>();
        Iterator iterator = a0.iterator();
        while (iterator.hasNext()) {
            n = (WtNode)iterator.next();
            if (n.getNodeType() != 720929) continue;
            a = (WtXmlAttribute)n;
            if (!a.getName().isResolved()) {
                return false;
            }
            m0.put(a.getName().getAsString(), a.getValue());
        }
        iterator = a1.iterator();
        while (iterator.hasNext()) {
            WtValue v1;
            n = (WtNode)iterator.next();
            if (n.getNodeType() != 720929) continue;
            a = (WtXmlAttribute)n;
            if (!a.getName().isResolved()) {
                return false;
            }
            WtNodeList v0 = (WtNodeList)m0.remove(a.getName().getAsString());
            if (v0 == (v1 = a.getValue())) {
                return true;
            }
            if (WtComparer.compareNoThrow(v0, v1, false, false)) continue;
            return false;
        }
        return m0.isEmpty();
    }

    void ignore(WtNode node) {
        switch (node.getNodeType()) {
            case 720934: 
            case 720935: 
            case 720936: 
            case 720944: 
            case 720945: {
                if (WtNodeFlags.isRepairNode(node) || !this.hasNonEmptyRtd(node)) break;
                this.appendToCurrentNode(node);
                break;
            }
            default: {
                ((TreeBuilderModeBase)this.logic.getImpl()).dispatch(this.getFactory().text(WtRtDataPrinter.print(node)));
            }
        }
    }

    private boolean hasNonEmptyRtd(WtNode node) {
        WtRtData rtd = node.getRtd();
        if (rtd == null) {
            return false;
        }
        for (Object[] glue : rtd.getFields()) {
            if (glue.length == 0) continue;
            return true;
        }
        return false;
    }

    void error(WtNode node, String message) {
        if (node instanceof WtImStartTag || node instanceof WtImEndTag) {
            return;
        }
        this.errors.add(new TreeBuilderWarning(node, message));
    }

    WtNode insertAnHtmlElement(WtNode sample) {
        WtNode newNode = this.factory.createNewElement(sample);
        this.appendToCurrentNode(newNode);
        this.getStack().push(newNode);
        return newNode;
    }

    WtNode insertAnHtmlRepairFormattingElement(WtNode sample) {
        WtNode newNode = this.factory.createRepairFormattingElement(sample);
        this.appendToCurrentNode(newNode);
        this.getStack().push(newNode);
        return newNode;
    }

    void insertText(WtText text) {
        WtNode last = this.pollLastChildOfCurrentNode();
        if (!text.hasAttributes() && last != null && !last.hasAttributes() && last instanceof WtText) {
            WtText lastText = (WtText)last;
            lastText.setContent(lastText.getContent() + text.getContent());
        } else {
            this.appendToCurrentNode(text);
        }
    }

    WtNode getCurrentNode() {
        assert (!this.getStack().isEmpty());
        return this.getStack().peek();
    }

    void appendToCurrentNode(WtNode e) {
        if (this.fosterParentingMode && this.getConfig().isFosterParenting() && this.isCurrentNodeTypeOneOf(ElementType.TABLE, ElementType.TBODY, ElementType.TFOOT, ElementType.THEAD, ElementType.TR) && (this.getConfig().isFosterParentingForTransclusions() || !this.isTransclusionTypeNode(e))) {
            this.insertInFosterParent(e);
        } else {
            this.getContentOfNodeForModification(this.getCurrentNode()).add(e);
        }
    }

    private boolean isTransclusionTypeNode(WtNode e) {
        switch (e.getNodeType()) {
            case 458756: 
            case 458758: {
                return true;
            }
        }
        return false;
    }

    WtNode pollLastChildOfCurrentNode() {
        WtNodeList content = this.getContentOfNode(this.getCurrentNode());
        if (content.isEmpty()) {
            return null;
        }
        return (WtNode)content.get(content.size() - 1);
    }

    boolean isCurrentNodeTypeOneOf(ElementType ... nodeTypes) {
        return TreeBuilder.isNodeTypeOneOf(this.getCurrentNode(), nodeTypes);
    }

    boolean isElementTypeInSpecificScope(StackScope scope, ElementType targetType) {
        Iterator i = this.getStack().iterator();
        while (i.hasNext()) {
            ElementType nodeType = TreeBuilder.getNodeType((WtNode)i.next());
            if (nodeType == targetType) {
                return true;
            }
            if (!scope.isInList(nodeType)) continue;
            return false;
        }
        throw new AssertionError((Object)"This should never happen!");
    }

    boolean isElementTypeInScope(ElementType elementType) {
        return this.isElementTypeInSpecificScope(StackScope.GENERAL_SCOPE, elementType);
    }

    boolean isElementTypeInListScope(ElementType elementType) {
        return this.isElementTypeInSpecificScope(StackScope.LIST_ITEM_SCOPE, elementType);
    }

    boolean isElementTypeInButtonScope(ElementType elementType) {
        return this.isElementTypeInSpecificScope(StackScope.BUTTON_SCOPE, elementType);
    }

    boolean isElementTypeInTableScope(ElementType elementType) {
        return this.isElementTypeInSpecificScope(StackScope.TABLE_SCOPE, elementType);
    }

    boolean isOneOfElementTypesInSpecificScope(StackScope scope, ElementType ... targetTypes) {
        Iterator i = this.getStack().iterator();
        while (i.hasNext()) {
            ElementType nodeType = TreeBuilder.getNodeType((WtNode)i.next());
            if (TreeBuilder.isTypeOneOf(nodeType, targetTypes)) {
                return true;
            }
            if (!scope.isInList(nodeType)) continue;
            return false;
        }
        throw new AssertionError((Object)"This should never happen!");
    }

    boolean isOneOfElementTypesInScope(ElementType ... targetTypes) {
        return this.isOneOfElementTypesInSpecificScope(StackScope.GENERAL_SCOPE, targetTypes);
    }

    boolean isNodeInSpecificScope(StackScope scope, WtNode targetNode) {
        WtNode node;
        Iterator i = this.getStack().iterator();
        do {
            if (!TreeBuilder.isSameTag(node = (WtNode)i.next(), targetNode)) continue;
            return true;
        } while (!scope.isInList(TreeBuilder.getNodeType(node)));
        return false;
    }

    boolean isNodeRefInSpecificScope(StackScope scope, WtNode targetNode) {
        WtNode node;
        Iterator i = this.getStack().iterator();
        do {
            if ((node = (WtNode)i.next()) != targetNode) continue;
            return true;
        } while (!scope.isInList(TreeBuilder.getNodeType(node)));
        return false;
    }

    boolean isNodeRefInScope(WtNode targetNode) {
        return this.isNodeRefInSpecificScope(StackScope.GENERAL_SCOPE, targetNode);
    }

    void removeFromStack(WtNode node) {
        Iterator i = this.getStack().iterator();
        while (i.hasNext()) {
            if (i.next() != node) continue;
            i.remove();
            return;
        }
        throw new AssertionError((Object)"Could not remove node from stack!");
    }

    boolean isInStackOfOpenElements(WtNode node) {
        for (WtNode e : this.getStack()) {
            if (e != node) continue;
            return true;
        }
        return false;
    }

    WtNode getFromStack(ElementType nodeType) {
        for (WtNode e : this.getStack()) {
            if (TreeBuilder.getNodeType(e) != nodeType) continue;
            return e;
        }
        return null;
    }

    WtNode popFromStackUntilIncluding(WtNode nodeExample) {
        while (!this.getStack().isEmpty()) {
            WtNode found = this.popFromStack();
            if (!TreeBuilder.isSameTag(nodeExample, found)) continue;
            return found;
        }
        throw new AssertionError((Object)"Everything's gone :(");
    }

    WtNode popFromStackUntilIncluding(ElementType nodeType) {
        while (!this.getStack().isEmpty()) {
            WtNode found = this.popFromStack();
            if (TreeBuilder.getNodeType(found) != nodeType) continue;
            return found;
        }
        throw new AssertionError((Object)"Everything's gone :(");
    }

    WtNode popFromStackUntilIncluding(ElementType ... nodeTypes) {
        while (!this.getStack().isEmpty()) {
            WtNode found = this.popFromStack();
            if (!TreeBuilder.isTypeOneOf(TreeBuilder.getNodeType(found), nodeTypes)) continue;
            return found;
        }
        throw new AssertionError((Object)"Everything's gone :(");
    }

    void popFromStackUntilIncludingRef(WtNode node) {
        while (this.popFromStack() != node) {
        }
        if (this.getStack().isEmpty()) {
            throw new AssertionError((Object)"Everything's gone :(");
        }
    }

    void popFromStackUntilExcluding(ElementType ... nodeTypes) {
        while (!TreeBuilder.isTypeOneOf(TreeBuilder.getNodeType(this.getCurrentNode()), nodeTypes)) {
            this.popFromStack();
        }
        if (this.getStack().isEmpty()) {
            throw new AssertionError((Object)"Everything's gone :(");
        }
    }

    WtNode popFromStack() {
        return this.getStack().pop();
    }

    void clearStackBackToTableContext() {
        this.popFromStackUntilExcluding(ElementType.PAGE, ElementType.TABLE);
    }

    void clearStackBackToTableBodyContext() {
        this.popFromStackUntilExcluding(ElementType.PAGE, ElementType.TBODY, ElementType.TFOOT, ElementType.THEAD);
    }

    void clearStackBackToTableRowContext() {
        this.popFromStackUntilExcluding(ElementType.PAGE, ElementType.TR);
    }

    WtNode getAboveOnStack(WtNode node) {
        Iterator i = this.getStack().iterator();
        while (i.hasNext()) {
            if (i.next() != node || !i.hasNext()) continue;
            return (WtNode)i.next();
        }
        return null;
    }

    void insertOnStackBelow(WtNode marker, WtNode node) {
        ListIterator<WtNode> i = this.getStack().listIterator();
        while (i.hasNext()) {
            if (i.next() != marker) continue;
            i.previous();
            i.add(node);
            return;
        }
        throw new AssertionError((Object)"Marker MUST exist in stack!");
    }

    void removeFromParent(WtNode node, WtNode parent) {
        WtNodeList content = this.getContentOfNode(parent);
        ListIterator i = content.listIterator(content.size());
        while (i.hasPrevious()) {
            WtNode p = (WtNode)i.previous();
            if (p != node) continue;
            i.remove();
            return;
        }
        throw new AssertionError((Object)"Node given as parent IS NOT parent of other node!");
    }

    void generateImpliedEndTags(ElementType excludedType) {
        ElementType nodeType;
        while ((nodeType = TreeBuilder.getNodeType(this.getCurrentNode())) != excludedType && TreeBuilder.isTypeOneOf(nodeType, ElementType.DD, ElementType.DT, ElementType.LI, ElementType.P)) {
            this.popFromStack();
        }
    }

    void generateImpliedEndTags() {
        this.generateImpliedEndTags((ElementType)null);
    }

    void generateImpliedEndTags(WtNode node) {
        WtNode currentNode;
        ElementType nodeType;
        while (TreeBuilder.isTypeOneOf(nodeType = TreeBuilder.getNodeType(currentNode = this.getCurrentNode()), ElementType.DD, ElementType.DT, ElementType.LI, ElementType.P) && !TreeBuilder.isSameTag(currentNode, node)) {
            this.popFromStack();
        }
    }

    static boolean isSameTag(WtNode n0, WtNode n1) {
        ElementType t1;
        ElementType t0 = TreeBuilder.getNodeType(n0);
        if (t0 == (t1 = TreeBuilder.getNodeType(n1)) && t0 != ElementType.UNKNOWN) {
            return true;
        }
        if (t0 != t1) {
            return false;
        }
        if (n0 instanceof WtNamedXmlElement) {
            String name1;
            String name0 = ((WtNamedXmlElement)n0).getName();
            if (n1 instanceof WtNamedXmlElement && name0.equalsIgnoreCase(name1 = ((WtNamedXmlElement)n1).getName())) {
                return true;
            }
        }
        return false;
    }

    void pushActiveFormattingElements(WtNode node) {
        WtNode fe;
        int count = 0;
        Iterator<WtNode> i = this.activeFormattingElements.descendingIterator();
        while (i.hasNext() && (fe = i.next()) != MARKER) {
            if (TreeBuilder.isSameFormattingElement(fe, node)) {
                ++count;
            }
            if (count != 3) continue;
            i.remove();
            break;
        }
        this.activeFormattingElements.add(node);
    }

    boolean isInListOfActiveFormattingElements(WtNode node) {
        return this.activeFormattingElements.contains(node);
    }

    WtNode getActiveFormattingElement(ElementType nodeType) {
        Iterator<WtNode> i = this.activeFormattingElements.descendingIterator();
        while (i.hasNext()) {
            WtNode node = i.next();
            if (node == MARKER) {
                return null;
            }
            if (TreeBuilder.getNodeType(node) != nodeType) continue;
            return node;
        }
        return null;
    }

    void removeFromActiveFormattingElements(WtNode node) {
        Iterator<WtNode> i = this.activeFormattingElements.descendingIterator();
        while (i.hasNext()) {
            if (i.next() != node) continue;
            i.remove();
            return;
        }
        throw new AssertionError((Object)"Could not remove formatting element");
    }

    void replaceInListOfActiveFormattingElements(WtNode replacee, WtNode replacement) {
        ListIterator<WtNode> i = this.activeFormattingElements.listIterator(this.activeFormattingElements.size());
        while (i.hasPrevious()) {
            if (i.previous() != replacee) continue;
            i.set(replacement);
            return;
        }
        throw new AssertionError((Object)"Could not replace formatting element");
    }

    void reconstructActiveFormattingElements() {
        LinkedList<WtNode> list = this.activeFormattingElements;
        if (list.isEmpty()) {
            return;
        }
        WtNode last = list.getLast();
        if (last == MARKER || this.isInStackOfOpenElements(last)) {
            return;
        }
        int entryIndex = list.size() - 1;
        WtNode entry = list.get(entryIndex);
        while (entryIndex > 0) {
            if ((entry = list.get(--entryIndex)) != MARKER && !this.isInStackOfOpenElements(entry)) continue;
            entry = list.get(++entryIndex);
            break;
        }
        while (true) {
            WtNode newNode = this.insertAnHtmlRepairFormattingElement(entry);
            list.set(entryIndex, newNode);
            if (entryIndex == list.size() - 1) break;
            entry = list.get(++entryIndex);
        }
    }

    void insertMarkerInActiveFormattingElements() {
        WtNode e;
        this.activeFormattingElements.add(MARKER);
        LinkedList<WtNode> list = this.activeFormattingElements;
        ListIterator<WtNode> iter = list.listIterator(list.size());
        iter.previous();
        while (iter.hasPrevious() && (e = iter.previous()) != MARKER) {
            if (TreeBuilder.getNodeType(e) != ElementType.LCT_VAR_CONV) continue;
            this.activeFormattingElements.add(e);
            break;
        }
    }

    void clearActiveFormattingElementsToLastMarker() {
        Iterator<WtNode> i = this.activeFormattingElements.descendingIterator();
        while (i.hasNext()) {
            WtNode fe = i.next();
            i.remove();
            if (fe != MARKER) continue;
            break;
        }
    }

    void placeBookmarkAfter(WtNode node) {
        ListIterator<WtNode> i = this.activeFormattingElements.listIterator(this.activeFormattingElements.size());
        while (i.hasPrevious()) {
            WtNode fe = i.previous();
            if (fe != node) continue;
            i.next();
            i.add(BOOKMARK);
            return;
        }
        throw new AssertionError((Object)"This method must only be called if there definitily is a bookmark!");
    }

    void moveBookmarkAfter(WtNode node) {
        WtNode fe;
        ListIterator<WtNode> i = this.activeFormattingElements.listIterator(this.activeFormattingElements.size());
        while (i.hasPrevious()) {
            fe = i.previous();
            if (fe != node) continue;
            i.next();
            i.add(BOOKMARK);
            i.previous();
            break;
        }
        while (i.hasPrevious()) {
            fe = i.previous();
            if (fe != BOOKMARK) continue;
            i.remove();
            return;
        }
        throw new AssertionError((Object)"This method must only be called if there definitily is a bookmark!");
    }

    public void replaceBookmarkWithAndRemove(WtNode replacement, WtNode remove) {
        WtNode fe;
        ListIterator<WtNode> i = this.activeFormattingElements.listIterator(this.activeFormattingElements.size());
        while (i.hasPrevious()) {
            fe = i.previous();
            if (fe != BOOKMARK) continue;
            i.remove();
            i.add(replacement);
            break;
        }
        while (i.hasPrevious()) {
            fe = i.previous();
            if (fe != remove) continue;
            i.remove();
            return;
        }
        throw new AssertionError((Object)"This method must only be called if there definitily is a bookmark!");
    }

    void insertInFosterParent(WtNode node) {
        WtNode lastTable = this.getFromStack(ElementType.TABLE);
        if (lastTable != null) {
            WtNode fosterParent = this.getAboveOnStack(lastTable);
            WtNodeList content = this.getContentOfNodeForModification(fosterParent);
            int i = content.indexOf(lastTable);
            content.add(i, node);
        } else {
            this.getContentOfNodeForModification(this.getStack().getLast()).add(node);
        }
    }

    void setFosterParentingMode(boolean fosterParentingMode) {
        this.fosterParentingMode = fosterParentingMode;
    }

    static boolean isInlineImage(WtImageLink n) {
        switch (n.getFormat()) {
            case FRAME: 
            case THUMBNAIL: {
                return false;
            }
        }
        return n.getHAlign() == WtImageLink.ImageHorizAlign.UNSPECIFIED;
    }

    private static final class Bookmark
    extends WtLeafNode {
        private static final long serialVersionUID = 1L;

        private Bookmark() {
        }
    }
}

