/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.core.interceptor;

import java.util.Objects;
import org.ssssssss.magicapi.core.context.MagicUser;
import org.ssssssss.magicapi.core.exception.MagicLoginException;
import org.ssssssss.magicapi.core.interceptor.AuthorizationInterceptor;
import org.ssssssss.magicapi.utils.MD5Utils;

public class DefaultAuthorizationInterceptor
implements AuthorizationInterceptor {
    private final boolean requireLogin;
    private String validToken;
    private MagicUser configMagicUser;

    public DefaultAuthorizationInterceptor(String username, String password) {
        this.requireLogin = username != null && password != null;
        if (this.requireLogin) {
            this.validToken = MD5Utils.encrypt(String.format("%s||%s", username, password));
            this.configMagicUser = new MagicUser(username, username, this.validToken);
        }
    }

    @Override
    public boolean requireLogin() {
        return this.requireLogin;
    }

    @Override
    public MagicUser getUserByToken(String token) throws MagicLoginException {
        if (this.requireLogin && Objects.equals(this.validToken, token)) {
            return this.configMagicUser;
        }
        throw new MagicLoginException("token\u65e0\u6548");
    }

    @Override
    public MagicUser login(String username, String password) throws MagicLoginException {
        if (this.requireLogin && Objects.equals(MD5Utils.encrypt(String.format("%s||%s", username, password)), this.validToken)) {
            return this.configMagicUser;
        }
        throw new MagicLoginException("\u7528\u6237\u540d\u6216\u5bc6\u7801\u4e0d\u6b63\u786e");
    }
}

