/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.jcr.support;

import javax.jcr.Session;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataAccessException;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;
import org.springmodules.jcr.SessionFactory;
import org.springmodules.jcr.SessionFactoryUtils;
import org.springmodules.jcr.SessionHolder;

public class OpenSessionInViewInterceptor
extends HandlerInterceptorAdapter
implements InitializingBean {
    public static final String PARTICIPATE_SUFFIX = ".PARTICIPATE";
    protected final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private SessionFactory sessionFactory;

    public void setSessionFactory(SessionFactory sf) {
        this.sessionFactory = sf;
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws DataAccessException {
        if (TransactionSynchronizationManager.hasResource((Object)this.getSessionFactory())) {
            String participateAttributeName = this.getParticipateAttributeName();
            Integer count = (Integer)request.getAttribute(participateAttributeName);
            int newCount = count != null ? count + 1 : 1;
            request.setAttribute(this.getParticipateAttributeName(), (Object)new Integer(newCount));
        } else {
            this.logger.debug((Object)"Opening JCR session in OpenSessionInViewInterceptor");
            Session s = SessionFactoryUtils.getSession(this.getSessionFactory(), true);
            TransactionSynchronizationManager.bindResource((Object)this.getSessionFactory(), (Object)((Object)this.getSessionFactory().getSessionHolder(s)));
        }
        return true;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws DataAccessException {
        String participateAttributeName = this.getParticipateAttributeName();
        Integer count = (Integer)request.getAttribute(participateAttributeName);
        if (count != null) {
            if (count > 1) {
                request.setAttribute(participateAttributeName, (Object)new Integer(count - 1));
            } else {
                request.removeAttribute(participateAttributeName);
            }
        } else {
            SessionHolder sesHolder = (SessionHolder)((Object)TransactionSynchronizationManager.unbindResource((Object)this.getSessionFactory()));
            this.logger.debug((Object)"Closing JCR session in OpenSessionInViewInterceptor");
            SessionFactoryUtils.releaseSession(sesHolder.getSession(), this.getSessionFactory());
        }
    }

    protected String getParticipateAttributeName() {
        return this.getSessionFactory().toString() + PARTICIPATE_SUFFIX;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.sessionFactory == null) {
            throw new IllegalArgumentException("sessionFactory is required");
        }
    }
}

