/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.jcr.support;

import java.util.List;
import javax.jcr.Repository;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springmodules.jcr.SessionHolderProvider;
import org.springmodules.jcr.SessionHolderProviderManager;
import org.springmodules.jcr.support.GenericSessionHolderProvider;

public abstract class AbstractSessionHolderProviderManager
implements SessionHolderProviderManager {
    protected final Log log = LogFactory.getLog(this.getClass());
    protected SessionHolderProvider defaultProvider = new GenericSessionHolderProvider();

    public abstract List getProviders();

    public SessionHolderProvider getSessionProvider(Repository repository) {
        if (repository == null) {
            return this.defaultProvider;
        }
        String key = repository.getDescriptor("jcr.repository.name");
        List providers = this.getProviders();
        for (int i = 0; i < providers.size(); ++i) {
            SessionHolderProvider provider = (SessionHolderProvider)providers.get(i);
            if (!provider.acceptsRepository(key)) continue;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("specific SessionHolderProvider found for repository " + key));
            }
            return provider;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("no specific SessionHolderProvider found for repository " + key + "; using the default one"));
        }
        return this.defaultProvider;
    }
}

