/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.jcr.jeceira;

import com.jeceira.config.ConfigManager;
import com.jeceira.config.DefaultConfigManager;
import com.jeceira.repository.RepositoryFactory;
import javax.jcr.Repository;
import org.springframework.core.io.ClassPathResource;

public class RepositoryFactoryBean
extends org.springmodules.jcr.RepositoryFactoryBean {
    private static final String DEFAULT_CONF_FILE = "jeceira.xml";
    private String repositoryName;
    private ConfigManager configManager;

    protected Repository createRepository() throws Exception {
        RepositoryFactory factory = RepositoryFactory.getInstance((ConfigManager)this.configManager);
        return factory.getRepository(this.repositoryName);
    }

    protected void resolveConfigurationResource() throws Exception {
        if (this.repositoryName == null) {
            throw new IllegalArgumentException("repositoryName is required");
        }
        if (this.configManager == null) {
            if (this.configuration == null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"no configuration resource specified, using the default one:jeceira.xml");
                }
                this.configuration = new ClassPathResource(DEFAULT_CONF_FILE);
            }
            this.configManager = new DefaultConfigManager(this.configuration.getInputStream());
        }
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public void setRepositoryName(String repositoryName) {
        this.repositoryName = repositoryName;
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public void setConfigManager(ConfigManager configManager) {
        this.configManager = configManager;
    }
}

