/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.jcr.jackrabbit;

import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.api.XASession;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.transaction.CannotCreateTransactionException;
import org.springframework.transaction.InvalidIsolationLevelException;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.transaction.support.AbstractPlatformTransactionManager;
import org.springframework.transaction.support.DefaultTransactionStatus;
import org.springframework.transaction.support.SmartTransactionObject;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springmodules.jcr.SessionFactory;
import org.springmodules.jcr.SessionFactoryUtils;
import org.springmodules.jcr.SessionHolder;
import org.springmodules.jcr.jackrabbit.support.UserTxSessionHolder;

public class LocalTransactionManager
extends AbstractPlatformTransactionManager
implements InitializingBean {
    private SessionFactory sessionFactory;

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public LocalTransactionManager() {
    }

    public LocalTransactionManager(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.getSessionFactory() == null) {
            throw new IllegalArgumentException("repository is required");
        }
    }

    protected Object doGetTransaction() throws TransactionException {
        JcrTransactionObject txObject = new JcrTransactionObject();
        if (TransactionSynchronizationManager.hasResource((Object)this.getSessionFactory())) {
            UserTxSessionHolder sessionHolder = (UserTxSessionHolder)((Object)TransactionSynchronizationManager.getResource((Object)this.getSessionFactory()));
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Found thread-bound session [" + sessionHolder.getSession() + "] for JCR transaction"));
            }
            txObject.setSessionHolder(sessionHolder, false);
        }
        return txObject;
    }

    protected boolean isExistingTransaction(Object transaction) throws TransactionException {
        return ((JcrTransactionObject)transaction).hasTransaction();
    }

    protected void doBegin(Object transaction, TransactionDefinition transactionDefinition) throws TransactionException {
        if (transactionDefinition.getIsolationLevel() != -1) {
            throw new InvalidIsolationLevelException("JCR does not support an isolation level concept");
        }
        XASession session = null;
        try {
            JcrTransactionObject txObject = (JcrTransactionObject)transaction;
            if (txObject.getSessionHolder() == null) {
                Session newSession = this.sessionFactory.getSession();
                if (!(newSession instanceof XASession)) {
                    throw new IllegalArgumentException("transactions are not supported by your Jcr Repository");
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Opened new session [" + newSession + "] for JCR transaction"));
                }
                txObject.setSessionHolder(new UserTxSessionHolder(newSession), true);
            }
            UserTxSessionHolder sessionHolder = txObject.getSessionHolder();
            sessionHolder.setSynchronizedWithTransaction(true);
            session = (XASession)sessionHolder.getSession();
            sessionHolder.getTransaction().begin();
            if (transactionDefinition.getTimeout() != -1) {
                txObject.getSessionHolder().setTimeoutInSeconds(transactionDefinition.getTimeout());
            }
            if (txObject.isNewSessionHolder()) {
                TransactionSynchronizationManager.bindResource((Object)this.getSessionFactory(), (Object)((Object)sessionHolder));
            }
        }
        catch (Exception ex) {
            SessionFactoryUtils.releaseSession(session, this.getSessionFactory());
            throw new CannotCreateTransactionException("Could not open JCR session for transaction", (Throwable)ex);
        }
    }

    protected Object doSuspend(Object transaction) {
        JcrTransactionObject txObject = (JcrTransactionObject)transaction;
        txObject.setSessionHolder(null, false);
        UserTxSessionHolder sessionHolder = (UserTxSessionHolder)((Object)TransactionSynchronizationManager.unbindResource((Object)this.getSessionFactory()));
        return new SuspendedResourcesHolder(sessionHolder);
    }

    protected void doResume(Object transaction, Object suspendedResources) {
        SuspendedResourcesHolder resourcesHolder = (SuspendedResourcesHolder)suspendedResources;
        if (TransactionSynchronizationManager.hasResource((Object)this.getSessionFactory())) {
            TransactionSynchronizationManager.unbindResource((Object)this.getSessionFactory());
        }
        TransactionSynchronizationManager.bindResource((Object)this.getSessionFactory(), (Object)((Object)resourcesHolder.getSessionHolder()));
    }

    protected void doCommit(DefaultTransactionStatus status) {
        JcrTransactionObject txObject = (JcrTransactionObject)status.getTransaction();
        if (status.isDebug()) {
            this.logger.debug((Object)("Committing JCR transaction on session [" + txObject.getSessionHolder().getSession() + "]"));
        }
        try {
            txObject.getSessionHolder().getTransaction().commit();
        }
        catch (Exception ex) {
            throw new TransactionSystemException("Could not commit JCR transaction", (Throwable)ex);
        }
    }

    protected void doRollback(DefaultTransactionStatus status) {
        JcrTransactionObject txObject = (JcrTransactionObject)status.getTransaction();
        if (status.isDebug()) {
            this.logger.debug((Object)("Rolling back JCR transaction on session [" + txObject.getSessionHolder().getSession() + "]"));
        }
        try {
            txObject.getSessionHolder().getTransaction().rollback();
        }
        catch (Exception ex) {
            throw new TransactionSystemException("Could not roll back JCR transaction", (Throwable)ex);
        }
        finally {
            if (!txObject.isNewSessionHolder()) {
                try {
                    txObject.getSessionHolder().getSession().refresh(false);
                }
                catch (RepositoryException e) {}
            }
        }
    }

    protected void doSetRollbackOnly(DefaultTransactionStatus status) {
        JcrTransactionObject txObject = (JcrTransactionObject)status.getTransaction();
        if (status.isDebug()) {
            this.logger.debug((Object)("Setting JCR transaction on session [" + txObject.getSessionHolder().getSession() + "] rollback-only"));
        }
        txObject.setRollbackOnly();
    }

    protected void doCleanupAfterCompletion(Object transaction) {
        JcrTransactionObject txObject = (JcrTransactionObject)transaction;
        if (txObject.isNewSessionHolder()) {
            TransactionSynchronizationManager.unbindResource((Object)this.getSessionFactory());
        }
        Session session = txObject.getSessionHolder().getSession();
        if (txObject.isNewSessionHolder()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Closing JCR session [" + session + "] after transaction"));
            }
            SessionFactoryUtils.releaseSession(session, this.sessionFactory);
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Not closing pre-bound JCR session [" + session + "] after transaction"));
        }
        txObject.getSessionHolder().clear();
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    private static class SuspendedResourcesHolder {
        private final SessionHolder sessionHolder;

        private SuspendedResourcesHolder(SessionHolder sessionHolder) {
            this.sessionHolder = sessionHolder;
        }

        private SessionHolder getSessionHolder() {
            return this.sessionHolder;
        }
    }

    private static class JcrTransactionObject
    implements SmartTransactionObject {
        private UserTxSessionHolder sessionHolder;
        private boolean newSessionHolder;

        private JcrTransactionObject() {
        }

        public void setSessionHolder(UserTxSessionHolder sessionHolder, boolean newSessionHolder) {
            this.sessionHolder = sessionHolder;
            this.newSessionHolder = newSessionHolder;
        }

        public UserTxSessionHolder getSessionHolder() {
            return this.sessionHolder;
        }

        public boolean isNewSessionHolder() {
            return this.newSessionHolder;
        }

        public boolean hasTransaction() {
            return this.sessionHolder != null && this.sessionHolder.getTransaction() != null;
        }

        public void setRollbackOnly() {
            this.getSessionHolder().setRollbackOnly();
        }

        public boolean isRollbackOnly() {
            return this.getSessionHolder().isRollbackOnly();
        }
    }
}

