/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.jcr;

import javax.jcr.Session;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springmodules.jcr.JcrAccessor;
import org.springmodules.jcr.SessionFactoryUtils;

public class JcrInterceptor
extends JcrAccessor
implements MethodInterceptor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        boolean existingTransaction = false;
        Session session = SessionFactoryUtils.getSession(this.getSessionFactory(), true);
        if (TransactionSynchronizationManager.hasResource((Object)this.getSessionFactory())) {
            this.logger.debug((Object)"Found thread-bound Session for JCR interceptor");
            existingTransaction = true;
        } else {
            this.logger.debug((Object)"Using new Session for JCR interceptor");
            TransactionSynchronizationManager.bindResource((Object)this.getSessionFactory(), (Object)((Object)this.getSessionFactory().getSessionHolder(session)));
        }
        try {
            Object retVal;
            Object object = retVal = methodInvocation.proceed();
            return object;
        }
        finally {
            if (existingTransaction) {
                this.logger.debug((Object)"Not closing pre-bound JCR Session after interceptor");
            } else {
                TransactionSynchronizationManager.unbindResource((Object)this.getSessionFactory());
                SessionFactoryUtils.releaseSession(session, this.getSessionFactory());
            }
        }
    }
}

