/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.transport.mail;

import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.mail.Address;
import jakarta.mail.Header;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Service;
import jakarta.mail.Session;
import jakarta.mail.Transport;
import jakarta.mail.URLName;
import jakarta.mail.internet.InternetAddress;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import org.jspecify.annotations.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.transport.AbstractReceiverConnection;
import org.springframework.ws.transport.mail.MailTransportException;
import org.springframework.ws.transport.mail.support.MailTransportUtils;

public class MailReceiverConnection
extends AbstractReceiverConnection {
    private final Message requestMessage;
    private final Session session;
    private @Nullable Message responseMessage;
    private @Nullable ByteArrayOutputStream responseBuffer;
    private @Nullable String responseContentType;
    private @Nullable URLName transportUri;
    private @Nullable InternetAddress from;

    protected MailReceiverConnection(Message requestMessage, Session session) {
        Assert.notNull((Object)requestMessage, (String)"'requestMessage' must not be null");
        Assert.notNull((Object)session, (String)"'session' must not be null");
        this.requestMessage = requestMessage;
        this.session = session;
    }

    public Message getRequestMessage() {
        return this.requestMessage;
    }

    public Message getResponseMessage() {
        Assert.notNull((Object)this.responseMessage, (String)"ResponseMessage is not available");
        return this.responseMessage;
    }

    void setTransportUri(URLName transportUri) {
        this.transportUri = transportUri;
    }

    void setFrom(InternetAddress from) {
        this.from = from;
    }

    public URI getUri() throws URISyntaxException {
        try {
            Object[] recipients = this.requestMessage.getRecipients(Message.RecipientType.TO);
            if (!ObjectUtils.isEmpty((Object[])recipients) && recipients[0] instanceof InternetAddress) {
                return MailTransportUtils.toUri((InternetAddress)recipients[0], this.requestMessage.getSubject());
            }
            throw new URISyntaxException("", "Could not determine To header");
        }
        catch (MessagingException ex) {
            throw new URISyntaxException("", ex.getMessage());
        }
    }

    public @Nullable String getErrorMessage() throws IOException {
        return null;
    }

    public boolean hasError() throws IOException {
        return false;
    }

    public Iterator<String> getRequestHeaderNames() throws IOException {
        try {
            ArrayList<String> headers = new ArrayList<String>();
            Enumeration enumeration = this.requestMessage.getAllHeaders();
            while (enumeration.hasMoreElements()) {
                Header header = (Header)enumeration.nextElement();
                headers.add(header.getName());
            }
            return headers.iterator();
        }
        catch (MessagingException ex) {
            throw new IOException(ex.getMessage());
        }
    }

    public Iterator<String> getRequestHeaders(String name) throws IOException {
        try {
            String[] headers = this.requestMessage.getHeader(name);
            return Arrays.asList(headers).iterator();
        }
        catch (MessagingException ex) {
            throw new MailTransportException(ex);
        }
    }

    protected InputStream getRequestInputStream() throws IOException {
        try {
            return this.requestMessage.getInputStream();
        }
        catch (MessagingException ex) {
            throw new MailTransportException(ex);
        }
    }

    public void addResponseHeader(String name, String value) throws IOException {
        try {
            this.getResponseMessage().addHeader(name, value);
            if ("Content-Type".equals(name)) {
                this.responseContentType = value;
            }
        }
        catch (MessagingException ex) {
            throw new MailTransportException(ex);
        }
    }

    protected OutputStream getResponseOutputStream() throws IOException {
        Assert.state((this.responseBuffer != null ? 1 : 0) != 0, (String)"onSendBeforeWrite has not been called");
        return this.responseBuffer;
    }

    protected void onSendBeforeWrite(WebServiceMessage message) throws IOException {
        try {
            this.responseMessage = this.requestMessage.reply(false);
            this.responseMessage.setFrom((Address)this.from);
            this.responseBuffer = new ByteArrayOutputStream();
        }
        catch (MessagingException ex) {
            throw new MailTransportException(ex);
        }
    }

    protected void onSendAfterWrite(WebServiceMessage message) throws IOException {
        Transport transport = null;
        Assert.state((this.responseMessage != null ? 1 : 0) != 0, (String)"onSendAfterWrite has not been called");
        Assert.state((this.responseBuffer != null ? 1 : 0) != 0, (String)"onSendAfterWrite has not been called");
        Assert.notNull((Object)this.transportUri, (String)"'transportUri' must not be null");
        try {
            this.responseMessage.setDataHandler(new DataHandler((DataSource)new ByteArrayDataSource(this.responseBuffer.toByteArray(), this.responseContentType)));
            transport = this.session.getTransport(this.transportUri);
            transport.connect();
            this.responseMessage.saveChanges();
            transport.sendMessage(this.responseMessage, this.responseMessage.getAllRecipients());
        }
        catch (MessagingException ex) {
            try {
                throw new MailTransportException(ex);
            }
            catch (Throwable throwable) {
                MailTransportUtils.closeService(transport);
                throw throwable;
            }
        }
        MailTransportUtils.closeService((Service)transport);
    }

    private static final class ByteArrayDataSource
    implements DataSource {
        private final String contentType;
        private final byte[] data;

        ByteArrayDataSource(byte[] data, @Nullable String contentType) {
            this.data = data;
            this.contentType = contentType != null ? contentType : "application/octet-stream";
        }

        public String getContentType() {
            return this.contentType;
        }

        public InputStream getInputStream() throws IOException {
            return new ByteArrayInputStream(this.data);
        }

        public String getName() {
            return "ByteArrayDataSource";
        }

        public OutputStream getOutputStream() throws IOException {
            throw new UnsupportedOperationException();
        }
    }
}

