/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.transport.mail;

import jakarta.mail.Session;
import jakarta.mail.URLName;
import jakarta.mail.internet.AddressException;
import jakarta.mail.internet.InternetAddress;
import java.io.IOException;
import java.net.URI;
import java.util.Properties;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.ws.transport.WebServiceConnection;
import org.springframework.ws.transport.WebServiceMessageSender;
import org.springframework.ws.transport.mail.MailSenderConnection;
import org.springframework.ws.transport.mail.support.MailTransportUtils;

public class MailMessageSender
implements WebServiceMessageSender,
InitializingBean {
    public static final long DEFAULT_RECEIVE_TIMEOUT = 60000L;
    private long receiveSleepTime = 60000L;
    private Session session = Session.getInstance((Properties)new Properties(), null);
    private @Nullable URLName storeUri;
    private @Nullable URLName transportUri;
    private @Nullable InternetAddress from;

    public void setFrom(String from) throws AddressException {
        this.from = new InternetAddress(from);
    }

    public void setJavaMailProperties(Properties javaMailProperties) {
        this.session = Session.getInstance((Properties)javaMailProperties, null);
    }

    public void setReceiveSleepTime(long receiveSleepTime) {
        this.receiveSleepTime = receiveSleepTime;
    }

    public void setSession(Session session) {
        Assert.notNull((Object)session, (String)"Session must not be null");
        this.session = session;
    }

    public void setStoreUri(String storeUri) {
        this.storeUri = new URLName(storeUri);
    }

    public void setTransportUri(String transportUri) {
        this.transportUri = new URLName(transportUri);
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.transportUri, (String)"'transportUri' is required");
        Assert.notNull((Object)this.storeUri, (String)"'storeUri' is required");
    }

    public WebServiceConnection createConnection(URI uri) throws IOException {
        String subject;
        Assert.notNull((Object)this.transportUri, (String)"'transportUri' is required");
        Assert.notNull((Object)this.storeUri, (String)"'storeUri' is required");
        InternetAddress to = MailTransportUtils.getTo(uri);
        Assert.notNull((Object)to, (String)("No TO address found for '" + String.valueOf(uri) + "'"));
        MailSenderConnection connection = new MailSenderConnection(this.session, this.transportUri, this.storeUri, to, this.receiveSleepTime);
        if (this.from != null) {
            connection.setFrom(this.from);
        }
        if ((subject = MailTransportUtils.getSubject(uri)) != null) {
            connection.setSubject(subject);
        }
        return connection;
    }

    public boolean supports(URI uri) {
        return uri.getScheme().equals("mailto");
    }
}

