/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.client.match;

import java.net.URI;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPathExpressionException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.test.util.AssertionErrors;
import org.springframework.test.web.client.RequestMatcher;
import org.springframework.test.web.client.match.ContentRequestMatchers;
import org.springframework.test.web.client.match.JsonPathRequestMatchers;
import org.springframework.test.web.client.match.XpathRequestMatchers;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponentsBuilder;

public abstract class MockRestRequestMatchers {
    public static RequestMatcher anything() {
        return request2 -> {};
    }

    public static RequestMatcher method(HttpMethod method) {
        Assert.notNull((Object)method, (String)"'method' must not be null");
        return request2 -> AssertionErrors.assertEquals("Unexpected HttpMethod", method, request2.getMethod());
    }

    public static RequestMatcher requestTo(Matcher<? super String> matcher) {
        Assert.notNull(matcher, (String)"'matcher' must not be null");
        return request2 -> MatcherAssert.assertThat((String)"Request URI", (Object)request2.getURI().toString(), (Matcher)matcher);
    }

    public static RequestMatcher requestTo(String expectedUri) {
        Assert.notNull((Object)expectedUri, (String)"'uri' must not be null");
        return request2 -> AssertionErrors.assertEquals("Request URI", expectedUri, request2.getURI().toString());
    }

    public static RequestMatcher requestToUriTemplate(String expectedUri, Object ... uriVars) {
        Assert.notNull((Object)expectedUri, (String)"'uri' must not be null");
        URI uri = UriComponentsBuilder.fromUriString((String)expectedUri).buildAndExpand(uriVars).encode().toUri();
        return MockRestRequestMatchers.requestTo(uri);
    }

    public static RequestMatcher requestTo(URI uri) {
        Assert.notNull((Object)uri, (String)"'uri' must not be null");
        return request2 -> AssertionErrors.assertEquals("Unexpected request", uri, request2.getURI());
    }

    public static RequestMatcher queryParam(String name, Matcher<? super List<String>> matcher) {
        return request2 -> {
            MultiValueMap<String, String> params = MockRestRequestMatchers.getQueryParams(request2);
            List paramValues = (List)params.get((Object)name);
            if (paramValues == null) {
                AssertionErrors.fail("Expected query param <" + name + "> to exist but was null");
            }
            MatcherAssert.assertThat((String)("Query param [" + name + "] values"), (Object)paramValues, (Matcher)matcher);
        };
    }

    @SafeVarargs
    public static RequestMatcher queryParam(String name, Matcher<? super String> ... matchers) {
        return request2 -> {
            MultiValueMap<String, String> params = MockRestRequestMatchers.getQueryParams(request2);
            MockRestRequestMatchers.assertValueCount("query param", name, params, matchers.length);
            for (int i = 0; i < matchers.length; ++i) {
                MatcherAssert.assertThat((String)"Query param", (Object)((String)((List)params.get((Object)name)).get(i)), (Matcher)matchers[i]);
            }
        };
    }

    public static RequestMatcher queryParam(String name, String ... expectedValues) {
        return request2 -> {
            MultiValueMap<String, String> params = MockRestRequestMatchers.getQueryParams(request2);
            MockRestRequestMatchers.assertValueCount("query param", name, params, expectedValues.length);
            for (int i = 0; i < expectedValues.length; ++i) {
                AssertionErrors.assertEquals("Query param [" + name + "]", expectedValues[i], ((List)params.get((Object)name)).get(i));
            }
        };
    }

    private static MultiValueMap<String, String> getQueryParams(ClientHttpRequest request2) {
        return UriComponentsBuilder.fromUri((URI)request2.getURI()).build().getQueryParams();
    }

    public static RequestMatcher header(String name, Matcher<? super List<String>> matcher) {
        return request2 -> {
            List headerValues = request2.getHeaders().get((Object)name);
            if (headerValues == null) {
                AssertionErrors.fail("Expected header <" + name + "> to exist but was null");
            }
            MatcherAssert.assertThat((String)("Request header [" + name + "] values"), (Object)headerValues, (Matcher)matcher);
        };
    }

    @SafeVarargs
    public static RequestMatcher header(String name, Matcher<? super String> ... matchers) {
        return request2 -> {
            MockRestRequestMatchers.assertValueCount("header", name, (MultiValueMap<String, String>)request2.getHeaders(), matchers.length);
            List headerValues = request2.getHeaders().get((Object)name);
            Assert.state((headerValues != null ? 1 : 0) != 0, (String)"No header values");
            for (int i = 0; i < matchers.length; ++i) {
                MatcherAssert.assertThat((String)("Request header [" + name + "]"), (Object)((String)headerValues.get(i)), (Matcher)matchers[i]);
            }
        };
    }

    public static RequestMatcher header(String name, String ... expectedValues) {
        return request2 -> {
            MockRestRequestMatchers.assertValueCount("header", name, (MultiValueMap<String, String>)request2.getHeaders(), expectedValues.length);
            List headerValues = request2.getHeaders().get((Object)name);
            Assert.state((headerValues != null ? 1 : 0) != 0, (String)"No header values");
            for (int i = 0; i < expectedValues.length; ++i) {
                AssertionErrors.assertEquals("Request header [" + name + "]", expectedValues[i], headerValues.get(i));
            }
        };
    }

    public static RequestMatcher headerDoesNotExist(String name) {
        return request2 -> {
            List headerValues = request2.getHeaders().get((Object)name);
            if (headerValues != null) {
                AssertionErrors.fail("Expected header <" + name + "> not to exist, but it exists with values: " + headerValues);
            }
        };
    }

    public static ContentRequestMatchers content() {
        return new ContentRequestMatchers();
    }

    public static JsonPathRequestMatchers jsonPath(String expression, Object ... args) {
        return new JsonPathRequestMatchers(expression, args);
    }

    public static <T> RequestMatcher jsonPath(String expression, Matcher<? super T> matcher) {
        return new JsonPathRequestMatchers(expression, new Object[0]).value(matcher);
    }

    public static XpathRequestMatchers xpath(String expression, Object ... args) throws XPathExpressionException {
        return new XpathRequestMatchers(expression, null, args);
    }

    public static XpathRequestMatchers xpath(String expression, Map<String, String> namespaces, Object ... args) throws XPathExpressionException {
        return new XpathRequestMatchers(expression, namespaces, args);
    }

    private static void assertValueCount(String valueType, String name, MultiValueMap<String, String> map, int count) {
        List values = (List)map.get((Object)name);
        String message = "Expected " + valueType + " <" + name + ">";
        if (values == null) {
            AssertionErrors.fail(message + " to exist but was null");
        }
        if (count > values.size()) {
            AssertionErrors.fail(message + " to have at least <" + count + "> values but found " + values);
        }
    }
}

