/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionFuture;
import org.elasticsearch.action.admin.cluster.node.info.NodeInfo;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoAction;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoRequest;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoRequestBuilder;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoResponse;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequestBuilder;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.get.GetRequestBuilder;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.get.MultiGetRequestBuilder;
import org.elasticsearch.action.get.MultiGetResponse;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.MultiSearchRequest;
import org.elasticsearch.action.search.MultiSearchResponse;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.WriteRequestBuilder;
import org.elasticsearch.action.update.UpdateRequestBuilder;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.UpdateByQueryRequestBuilder;
import org.elasticsearch.search.suggest.SuggestBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.data.elasticsearch.core.AbstractElasticsearchRestTransportTemplate;
import org.springframework.data.elasticsearch.core.AbstractElasticsearchTemplate;
import org.springframework.data.elasticsearch.core.ElasticsearchExceptionTranslator;
import org.springframework.data.elasticsearch.core.IndexOperations;
import org.springframework.data.elasticsearch.core.IndexedObjectInformation;
import org.springframework.data.elasticsearch.core.MultiGetItem;
import org.springframework.data.elasticsearch.core.RefreshPolicy;
import org.springframework.data.elasticsearch.core.RequestFactory;
import org.springframework.data.elasticsearch.core.ResponseConverter;
import org.springframework.data.elasticsearch.core.SearchHits;
import org.springframework.data.elasticsearch.core.SearchScrollHits;
import org.springframework.data.elasticsearch.core.TransportIndexTemplate;
import org.springframework.data.elasticsearch.core.cluster.ClusterOperations;
import org.springframework.data.elasticsearch.core.convert.ElasticsearchConverter;
import org.springframework.data.elasticsearch.core.document.Document;
import org.springframework.data.elasticsearch.core.document.DocumentAdapters;
import org.springframework.data.elasticsearch.core.document.SearchDocumentResponse;
import org.springframework.data.elasticsearch.core.mapping.IndexCoordinates;
import org.springframework.data.elasticsearch.core.query.BulkOptions;
import org.springframework.data.elasticsearch.core.query.ByQueryResponse;
import org.springframework.data.elasticsearch.core.query.IndexQuery;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.data.elasticsearch.core.query.UpdateQuery;
import org.springframework.data.elasticsearch.core.query.UpdateResponse;
import org.springframework.data.elasticsearch.support.SearchHitsUtil;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

@Deprecated
public class ElasticsearchTemplate
extends AbstractElasticsearchRestTransportTemplate {
    private static final Logger QUERY_LOGGER = LoggerFactory.getLogger((String)"org.springframework.data.elasticsearch.core.QUERY");
    private static final Logger LOGGER = LoggerFactory.getLogger(ElasticsearchTemplate.class);
    private Client client;
    @Nullable
    private String searchTimeout;
    private final ElasticsearchExceptionTranslator exceptionTranslator = new ElasticsearchExceptionTranslator();

    public ElasticsearchTemplate(Client client) {
        this.client = client;
        this.initialize(client, this.createElasticsearchConverter());
    }

    public ElasticsearchTemplate(Client client, ElasticsearchConverter elasticsearchConverter) {
        this.client = client;
        this.initialize(client, elasticsearchConverter);
    }

    private void initialize(Client client, ElasticsearchConverter elasticsearchConverter) {
        Assert.notNull((Object)client, (String)"Client must not be null!");
        this.client = client;
        this.initialize(elasticsearchConverter);
    }

    @Override
    protected AbstractElasticsearchTemplate doCopy() {
        ElasticsearchTemplate elasticsearchTemplate = new ElasticsearchTemplate(this.client, this.elasticsearchConverter);
        elasticsearchTemplate.setSearchTimeout(this.searchTimeout);
        return elasticsearchTemplate;
    }

    @Override
    public IndexOperations indexOps(Class<?> clazz) {
        Assert.notNull(clazz, (String)"clazz must not be null");
        return new TransportIndexTemplate(this.client, this.elasticsearchConverter, clazz);
    }

    @Override
    public IndexOperations indexOps(IndexCoordinates index) {
        Assert.notNull((Object)index, (String)"index must not be null");
        return new TransportIndexTemplate(this.client, this.elasticsearchConverter, index);
    }

    @Override
    public ClusterOperations cluster() {
        return ClusterOperations.forTemplate(this);
    }

    @Nullable
    public String getSearchTimeout() {
        return this.searchTimeout;
    }

    public void setSearchTimeout(String searchTimeout) {
        this.searchTimeout = searchTimeout;
    }

    @Override
    public String doIndex(IndexQuery query, IndexCoordinates index) {
        IndexResponse response;
        IndexRequestBuilder indexRequestBuilder = this.requestFactory.indexRequestBuilder(this.client, query, index);
        indexRequestBuilder = this.prepareWriteRequestBuilder(indexRequestBuilder);
        ActionFuture future = indexRequestBuilder.execute();
        try {
            response = (IndexResponse)future.actionGet();
        }
        catch (RuntimeException e) {
            throw this.translateException(e);
        }
        String documentId = response.getId();
        Object queryObject = query.getObject();
        if (queryObject != null) {
            query.setObject(this.updateIndexedObject(queryObject, IndexedObjectInformation.of(documentId, response.getSeqNo(), response.getPrimaryTerm(), response.getVersion())));
        }
        return documentId;
    }

    @Override
    @Nullable
    public <T> T get(String id, Class<T> clazz, IndexCoordinates index) {
        GetRequestBuilder getRequestBuilder = this.requestFactory.getRequestBuilder(this.client, id, this.routingResolver.getRouting(), index);
        GetResponse response = (GetResponse)getRequestBuilder.execute().actionGet();
        AbstractElasticsearchTemplate.ReadDocumentCallback<T> callback = new AbstractElasticsearchTemplate.ReadDocumentCallback<T>(this.elasticsearchConverter, clazz, index);
        return callback.doWith(DocumentAdapters.from(response));
    }

    @Override
    public <T> List<MultiGetItem<T>> multiGet(Query query, Class<T> clazz, IndexCoordinates index) {
        Assert.notNull((Object)index, (String)"index must not be null");
        MultiGetRequestBuilder builder = this.requestFactory.multiGetRequestBuilder(this.client, query, clazz, index);
        AbstractElasticsearchTemplate.ReadDocumentCallback callback = new AbstractElasticsearchTemplate.ReadDocumentCallback(this.elasticsearchConverter, clazz, index);
        return DocumentAdapters.from((MultiGetResponse)builder.execute().actionGet()).stream().map(multiGetItem -> MultiGetItem.of(multiGetItem.isFailed() ? null : (Object)callback.doWith((Document)multiGetItem.getItem()), multiGetItem.getFailure())).collect(Collectors.toList());
    }

    @Override
    protected boolean doExists(String id, IndexCoordinates index) {
        GetRequestBuilder getRequestBuilder = this.requestFactory.getRequestBuilder(this.client, id, this.routingResolver.getRouting(), index);
        getRequestBuilder.setFetchSource(false);
        return ((GetResponse)getRequestBuilder.execute().actionGet()).isExists();
    }

    @Override
    public void bulkUpdate(List<UpdateQuery> queries, BulkOptions bulkOptions, IndexCoordinates index) {
        Assert.notNull(queries, (String)"List of UpdateQuery must not be null");
        Assert.notNull((Object)bulkOptions, (String)"BulkOptions must not be null");
        this.doBulkOperation(queries, bulkOptions, index);
    }

    @Override
    protected String doDelete(String id, @Nullable String routing, IndexCoordinates index) {
        Assert.notNull((Object)id, (String)"id must not be null");
        Assert.notNull((Object)index, (String)"index must not be null");
        DeleteRequestBuilder deleteRequestBuilder = this.prepareWriteRequestBuilder(this.requestFactory.deleteRequestBuilder(this.client, this.elasticsearchConverter.convertId(id), routing, index));
        return ((DeleteResponse)deleteRequestBuilder.execute().actionGet()).getId();
    }

    @Override
    public ByQueryResponse delete(Query query, Class<?> clazz, IndexCoordinates index) {
        return ResponseConverter.byQueryResponseOf((BulkByScrollResponse)this.requestFactory.deleteByQueryRequestBuilder(this.client, query, clazz, index).get());
    }

    @Override
    public String delete(Object entity, IndexCoordinates index) {
        return super.delete(entity, index);
    }

    @Override
    public UpdateResponse update(UpdateQuery query, IndexCoordinates index) {
        UpdateRequestBuilder updateRequestBuilder = this.requestFactory.updateRequestBuilderFor(this.client, query, index);
        if (query.getRefreshPolicy() == null && this.getRefreshPolicy() != null) {
            updateRequestBuilder.setRefreshPolicy(RequestFactory.toElasticsearchRefreshPolicy(this.getRefreshPolicy()));
        }
        if (query.getRouting() == null && this.routingResolver.getRouting() != null) {
            updateRequestBuilder.setRouting(this.routingResolver.getRouting());
        }
        org.elasticsearch.action.update.UpdateResponse updateResponse = (org.elasticsearch.action.update.UpdateResponse)updateRequestBuilder.execute().actionGet();
        UpdateResponse.Result result = UpdateResponse.Result.valueOf(updateResponse.getResult().name());
        return new UpdateResponse(result);
    }

    @Override
    public ByQueryResponse updateByQuery(UpdateQuery query, IndexCoordinates index) {
        Assert.notNull((Object)query, (String)"query must not be null");
        Assert.notNull((Object)index, (String)"index must not be null");
        UpdateByQueryRequestBuilder updateByQueryRequestBuilder = this.requestFactory.updateByQueryRequestBuilder(this.client, query, index);
        if (query.getRefreshPolicy() == null && this.getRefreshPolicy() != null) {
            updateByQueryRequestBuilder.refresh(this.getRefreshPolicy() == RefreshPolicy.IMMEDIATE);
        }
        BulkByScrollResponse bulkByScrollResponse = (BulkByScrollResponse)updateByQueryRequestBuilder.execute().actionGet();
        return ResponseConverter.byQueryResponseOf(bulkByScrollResponse);
    }

    @Override
    public List<IndexedObjectInformation> doBulkOperation(List<?> queries, BulkOptions bulkOptions, IndexCoordinates index) {
        Collection<List<?>> queryLists = this.partitionBasedOnSize(queries, 2500);
        ArrayList<IndexedObjectInformation> allIndexedObjectInformations = new ArrayList<IndexedObjectInformation>(queries.size());
        queryLists.forEach(queryList -> {
            BulkRequestBuilder bulkRequestBuilder = this.requestFactory.bulkRequestBuilder(this.client, (List<?>)queryList, bulkOptions, index);
            bulkRequestBuilder = this.prepareWriteRequestBuilder(bulkRequestBuilder);
            List<IndexedObjectInformation> indexedObjectInformations = this.checkForBulkOperationFailure((BulkResponse)bulkRequestBuilder.execute().actionGet());
            this.updateIndexedObjectsWithQueries((List<?>)queryList, indexedObjectInformations);
            allIndexedObjectInformations.addAll(indexedObjectInformations);
        });
        return allIndexedObjectInformations;
    }

    protected <R extends WriteRequestBuilder<R>> R prepareWriteRequestBuilder(R requestBuilder) {
        if (this.refreshPolicy == null) {
            return requestBuilder;
        }
        return (R)requestBuilder.setRefreshPolicy(RequestFactory.toElasticsearchRefreshPolicy(this.refreshPolicy));
    }

    @Override
    public long count(Query query, @Nullable Class<?> clazz, IndexCoordinates index) {
        Assert.notNull((Object)query, (String)"query must not be null");
        Assert.notNull((Object)index, (String)"index must not be null");
        Boolean trackTotalHits = query.getTrackTotalHits();
        query.setTrackTotalHits(true);
        SearchRequestBuilder searchRequestBuilder = this.requestFactory.searchRequestBuilder(this.client, query, clazz, index);
        query.setTrackTotalHits(trackTotalHits);
        searchRequestBuilder.setSize(0);
        return SearchHitsUtil.getTotalCount(this.getSearchResponse(searchRequestBuilder).getHits());
    }

    @Override
    public <T> SearchHits<T> search(Query query, Class<T> clazz, IndexCoordinates index) {
        SearchRequestBuilder searchRequestBuilder = this.requestFactory.searchRequestBuilder(this.client, query, clazz, index);
        SearchResponse response = this.getSearchResponse(searchRequestBuilder);
        AbstractElasticsearchTemplate.ReadDocumentCallback<T> documentCallback = new AbstractElasticsearchTemplate.ReadDocumentCallback<T>(this.elasticsearchConverter, clazz, index);
        AbstractElasticsearchTemplate.ReadSearchDocumentResponseCallback<T> callback = new AbstractElasticsearchTemplate.ReadSearchDocumentResponseCallback<T>(clazz, index);
        return (SearchHits)callback.doWith(SearchDocumentResponse.from(response, documentCallback::doWith));
    }

    @Override
    public <T> SearchScrollHits<T> searchScrollStart(long scrollTimeInMillis, Query query, Class<T> clazz, IndexCoordinates index) {
        Assert.notNull((Object)query.getPageable(), (String)"pageable of query must not be null.");
        ActionFuture action = this.requestFactory.searchRequestBuilder(this.client, query, clazz, index).setScroll(TimeValue.timeValueMillis((long)scrollTimeInMillis)).execute();
        SearchResponse response = this.getSearchResponseWithTimeout((ActionFuture<SearchResponse>)action);
        AbstractElasticsearchTemplate.ReadDocumentCallback<T> documentCallback = new AbstractElasticsearchTemplate.ReadDocumentCallback<T>(this.elasticsearchConverter, clazz, index);
        AbstractElasticsearchTemplate.ReadSearchScrollDocumentResponseCallback<T> callback = new AbstractElasticsearchTemplate.ReadSearchScrollDocumentResponseCallback<T>(clazz, index);
        return (SearchScrollHits)callback.doWith(SearchDocumentResponse.from(response, documentCallback::doWith));
    }

    @Override
    public <T> SearchScrollHits<T> searchScrollContinue(@Nullable String scrollId, long scrollTimeInMillis, Class<T> clazz, IndexCoordinates index) {
        ActionFuture action = this.client.prepareSearchScroll(scrollId).setScroll(TimeValue.timeValueMillis((long)scrollTimeInMillis)).execute();
        SearchResponse response = this.getSearchResponseWithTimeout((ActionFuture<SearchResponse>)action);
        AbstractElasticsearchTemplate.ReadDocumentCallback<T> documentCallback = new AbstractElasticsearchTemplate.ReadDocumentCallback<T>(this.elasticsearchConverter, clazz, index);
        AbstractElasticsearchTemplate.ReadSearchScrollDocumentResponseCallback<T> callback = new AbstractElasticsearchTemplate.ReadSearchScrollDocumentResponseCallback<T>(clazz, index);
        return (SearchScrollHits)callback.doWith(SearchDocumentResponse.from(response, documentCallback::doWith));
    }

    @Override
    public void searchScrollClear(List<String> scrollIds) {
        try {
            this.client.prepareClearScroll().setScrollIds(scrollIds).execute().actionGet();
        }
        catch (Exception e) {
            LOGGER.warn("Could not clear scroll: {}", (Object)e.getMessage());
        }
    }

    @Override
    public SearchResponse suggest(SuggestBuilder suggestion, IndexCoordinates index) {
        SearchRequestBuilder searchRequestBuilder = this.requestFactory.searchRequestBuilder(this.client, suggestion, index);
        return (SearchResponse)searchRequestBuilder.get();
    }

    @Override
    protected MultiSearchResponse.Item[] getMultiSearchResult(MultiSearchRequest request) {
        ActionFuture future = this.client.multiSearch(request);
        MultiSearchResponse response = (MultiSearchResponse)future.actionGet();
        MultiSearchResponse.Item[] items = response.getResponses();
        Assert.isTrue((items.length == request.requests().size() ? 1 : 0) != 0, (String)"Response should have same length with queries");
        return items;
    }

    private SearchResponse getSearchResponse(SearchRequestBuilder requestBuilder) {
        if (QUERY_LOGGER.isDebugEnabled()) {
            QUERY_LOGGER.debug(requestBuilder.toString());
        }
        return this.getSearchResponseWithTimeout((ActionFuture<SearchResponse>)requestBuilder.execute());
    }

    private SearchResponse getSearchResponseWithTimeout(ActionFuture<SearchResponse> response) {
        return this.searchTimeout == null ? (SearchResponse)response.actionGet() : (SearchResponse)response.actionGet(this.searchTimeout);
    }

    @Override
    protected String getClusterVersion() {
        try {
            NodesInfoResponse nodesInfoResponse = (NodesInfoResponse)this.client.admin().cluster().nodesInfo((NodesInfoRequest)new NodesInfoRequestBuilder((ElasticsearchClient)this.client, NodesInfoAction.INSTANCE).request()).actionGet();
            if (!nodesInfoResponse.getNodes().isEmpty()) {
                return ((NodeInfo)nodesInfoResponse.getNodes().get(0)).getVersion().toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public Client getClient() {
        return this.client;
    }

    <T> Collection<List<T>> partitionBasedOnSize(List<T> inputList, int size) {
        AtomicInteger counter = new AtomicInteger(0);
        return inputList.stream().collect(Collectors.groupingBy(s -> counter.getAndIncrement() / size)).values();
    }

    private RuntimeException translateException(Exception exception) {
        RuntimeException runtimeException = exception instanceof RuntimeException ? (RuntimeException)exception : new RuntimeException(exception.getMessage(), exception);
        DataAccessException potentiallyTranslatedException = this.exceptionTranslator.translateExceptionIfPossible(runtimeException);
        return potentiallyTranslatedException != null ? potentiallyTranslatedException : runtimeException;
    }
}

