/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.repository.support;

import java.util.Collection;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.index.query.QueryBuilders;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.elasticsearch.core.ReactiveElasticsearchOperations;
import org.springframework.data.elasticsearch.core.ReactiveElasticsearchTemplate;
import org.springframework.data.elasticsearch.core.ReactiveIndexOperations;
import org.springframework.data.elasticsearch.core.SearchHit;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentEntity;
import org.springframework.data.elasticsearch.core.mapping.IndexCoordinates;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.data.elasticsearch.core.query.StringQuery;
import org.springframework.data.elasticsearch.repository.ReactiveElasticsearchRepository;
import org.springframework.data.elasticsearch.repository.support.ElasticsearchEntityInformation;
import org.springframework.data.elasticsearch.repository.support.SimpleElasticsearchRepository;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class SimpleReactiveElasticsearchRepository<T, ID>
implements ReactiveElasticsearchRepository<T, ID> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleElasticsearchRepository.class);
    private final ElasticsearchEntityInformation<T, ID> entityInformation;
    private final ReactiveElasticsearchOperations operations;
    private final ReactiveIndexOperations indexOperations;

    public SimpleReactiveElasticsearchRepository(ElasticsearchEntityInformation<T, ID> entityInformation, ReactiveElasticsearchOperations operations) {
        Assert.notNull(entityInformation, (String)"EntityInformation must not be null!");
        Assert.notNull((Object)operations, (String)"ElasticsearchOperations must not be null!");
        this.entityInformation = entityInformation;
        this.operations = operations;
        this.indexOperations = operations.indexOps(entityInformation.getJavaType());
        this.createIndexAndMappingIfNeeded();
    }

    private void createIndexAndMappingIfNeeded() {
        try {
            if (this.shouldCreateIndexAndMapping()) {
                this.indexOperations.exists().flatMap(exists -> exists != false ? Mono.empty() : this.indexOperations.create()).flatMap(success -> success != false ? this.indexOperations.putMapping() : Mono.empty()).block();
            }
        }
        catch (Exception exception) {
            LOGGER.warn("Cannot create index: {}", (Object)exception.getMessage());
        }
    }

    private boolean shouldCreateIndexAndMapping() {
        ElasticsearchPersistentEntity entity = (ElasticsearchPersistentEntity)this.operations.getElasticsearchConverter().getMappingContext().getRequiredPersistentEntity(this.entityInformation.getJavaType());
        return entity.isCreateIndexAndMapping();
    }

    public <S extends T> Mono<S> save(S entity) {
        Assert.notNull(entity, (String)"Entity must not be null!");
        return this.operations.save(entity, this.entityInformation.getIndexCoordinates()).flatMap(saved -> this.doRefresh().thenReturn(saved));
    }

    public <S extends T> Flux<S> saveAll(Iterable<S> entities) {
        Assert.notNull(entities, (String)"Entities must not be null!");
        return this.saveAll((Publisher<S>)Flux.fromIterable(entities));
    }

    public <S extends T> Flux<S> saveAll(Publisher<S> entityStream) {
        Assert.notNull(entityStream, (String)"EntityStream must not be null!");
        return this.operations.saveAll(Flux.from(entityStream).collectList(), this.entityInformation.getIndexCoordinates()).concatWith((Publisher)this.doRefresh().then(Mono.empty()));
    }

    public Mono<T> findById(ID id) {
        Assert.notNull(id, (String)"Id must not be null!");
        return this.operations.get(this.convertId(id), this.entityInformation.getJavaType(), this.entityInformation.getIndexCoordinates());
    }

    public Mono<T> findById(Publisher<ID> id) {
        Assert.notNull(id, (String)"Id must not be null!");
        return Mono.from(id).flatMap(this::findById);
    }

    public Mono<Boolean> existsById(ID id) {
        Assert.notNull(id, (String)"Id must not be null!");
        return this.operations.exists(this.convertId(id), this.entityInformation.getIndexCoordinates());
    }

    public Mono<Boolean> existsById(Publisher<ID> id) {
        Assert.notNull(id, (String)"Id must not be null!");
        return Mono.from(id).flatMap(this::existsById);
    }

    public Flux<T> findAll() {
        return this.operations.search((Query)Query.findAll().setPageable(Pageable.unpaged()), this.entityInformation.getJavaType(), this.entityInformation.getIndexCoordinates()).map(SearchHit::getContent);
    }

    public Flux<T> findAll(Sort sort) {
        return this.operations.search((Query)Query.findAll().addSort(sort).setPageable(Pageable.unpaged()), this.entityInformation.getJavaType(), this.entityInformation.getIndexCoordinates()).map(SearchHit::getContent);
    }

    public Flux<T> findAllById(Iterable<ID> ids) {
        Assert.notNull(ids, (String)"Ids must not be null!");
        return this.findAllById((Publisher<ID>)Flux.fromIterable(ids));
    }

    public Flux<T> findAllById(Publisher<ID> idStream) {
        Assert.notNull(idStream, (String)"IdStream must not be null!");
        return Flux.from(idStream).map(Object::toString).collectList().map(ids -> new NativeSearchQueryBuilder().withIds((Collection<String>)ids).build()).flatMapMany(query -> {
            IndexCoordinates index = this.entityInformation.getIndexCoordinates();
            return this.operations.multiGet((Query)query, this.entityInformation.getJavaType(), index);
        });
    }

    public Mono<Long> count() {
        return this.operations.count(Query.findAll(), this.entityInformation.getJavaType(), this.entityInformation.getIndexCoordinates());
    }

    public Mono<Void> deleteById(ID id) {
        Assert.notNull(id, (String)"Id must not be null!");
        return this.operations.delete(this.convertId(id), this.entityInformation.getIndexCoordinates()).then(this.doRefresh());
    }

    public Mono<Void> deleteById(Publisher<ID> id) {
        Assert.notNull(id, (String)"Id must not be null!");
        return Mono.from(id).flatMap(this::deleteById);
    }

    public Mono<Void> delete(T entity) {
        Assert.notNull(entity, (String)"Entity must not be null!");
        return this.operations.delete(entity, this.entityInformation.getIndexCoordinates()).then(this.doRefresh());
    }

    public Mono<Void> deleteAll(Iterable<? extends T> entities) {
        Assert.notNull(entities, (String)"Entities must not be null!");
        return this.deleteAll((Publisher<? extends T>)Flux.fromIterable(entities));
    }

    public Mono<Void> deleteAll(Publisher<? extends T> entityStream) {
        Assert.notNull(entityStream, (String)"EntityStream must not be null!");
        return Flux.from(entityStream).map(entity -> {
            Object id = this.entityInformation.getId(entity);
            if (id == null) {
                throw new IllegalStateException("Entity id must not be null!");
            }
            return this.convertId(id);
        }).collectList().map(objects -> new StringQuery(QueryBuilders.idsQuery().addIds(objects.toArray(new String[0])).toString())).flatMap(query -> this.operations.delete((Query)query, (Class<?>)this.entityInformation.getJavaType(), this.entityInformation.getIndexCoordinates())).then(this.doRefresh());
    }

    public Mono<Void> deleteAll() {
        return this.operations.delete(Query.findAll(), this.entityInformation.getJavaType(), this.entityInformation.getIndexCoordinates()).then(this.doRefresh());
    }

    private String convertId(Object id) {
        return this.operations.getElasticsearchConverter().convertId(id);
    }

    private Mono<Void> doRefresh() {
        WriteRequest.RefreshPolicy refreshPolicy = null;
        if (this.operations instanceof ReactiveElasticsearchTemplate) {
            refreshPolicy = ((ReactiveElasticsearchTemplate)this.operations).getRefreshPolicy();
        }
        if (refreshPolicy == null || refreshPolicy == WriteRequest.RefreshPolicy.NONE) {
            return this.indexOperations.refresh();
        }
        return Mono.empty();
    }
}

