/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.server.mvc.filter;

import java.net.URI;
import java.util.function.Consumer;
import org.springframework.cloud.gateway.server.mvc.common.HttpStatusHolder;
import org.springframework.cloud.gateway.server.mvc.common.KeyValues;
import org.springframework.cloud.gateway.server.mvc.common.Shortcut;
import org.springframework.cloud.gateway.server.mvc.filter.AfterFilterFunctions;
import org.springframework.cloud.gateway.server.mvc.filter.BeforeFilterFunctions;
import org.springframework.cloud.gateway.server.mvc.filter.RewriteLocationResponseHeaderFilterFunctions;
import org.springframework.cloud.gateway.server.mvc.filter.SimpleFilterSupplier;
import org.springframework.http.HttpStatusCode;
import org.springframework.util.Assert;
import org.springframework.util.unit.DataSize;
import org.springframework.web.servlet.function.HandlerFilterFunction;
import org.springframework.web.servlet.function.ServerResponse;

public interface FilterFunctions {
    @Shortcut
    public static HandlerFilterFunction<ServerResponse, ServerResponse> adaptCachedBody() {
        return HandlerFilterFunction.ofRequestProcessor(BeforeFilterFunctions.adaptCachedBody());
    }

    @Shortcut
    public static HandlerFilterFunction<ServerResponse, ServerResponse> addRequestHeader(String name, String ... values) {
        return HandlerFilterFunction.ofRequestProcessor(BeforeFilterFunctions.addRequestHeader(name, values));
    }

    public static HandlerFilterFunction<ServerResponse, ServerResponse> addRequestHeadersIfNotPresent(String values) {
        return FilterFunctions.addRequestHeadersIfNotPresent(KeyValues.valueOf(values));
    }

    @Shortcut
    public static HandlerFilterFunction<ServerResponse, ServerResponse> addRequestHeadersIfNotPresent(KeyValues keyValues) {
        return HandlerFilterFunction.ofRequestProcessor(BeforeFilterFunctions.addRequestHeadersIfNotPresent(keyValues.getKeyValues()));
    }

    @Shortcut
    public static HandlerFilterFunction<ServerResponse, ServerResponse> addRequestParameter(String name, String ... values) {
        return HandlerFilterFunction.ofRequestProcessor(BeforeFilterFunctions.addRequestParameter(name, values));
    }

    @Shortcut
    public static HandlerFilterFunction<ServerResponse, ServerResponse> addResponseHeader(String name, String ... values) {
        return HandlerFilterFunction.ofResponseProcessor(AfterFilterFunctions.addResponseHeader(name, values));
    }

    public static HandlerFilterFunction<ServerResponse, ServerResponse> dedupeResponseHeader(String name) {
        return HandlerFilterFunction.ofResponseProcessor(AfterFilterFunctions.dedupeResponseHeader(name));
    }

    @Shortcut
    public static HandlerFilterFunction<ServerResponse, ServerResponse> dedupeResponseHeader(String name, AfterFilterFunctions.DedupeStrategy strategy) {
        return HandlerFilterFunction.ofResponseProcessor(AfterFilterFunctions.dedupeResponseHeader(name, strategy));
    }

    @Shortcut
    public static HandlerFilterFunction<ServerResponse, ServerResponse> fallbackHeaders() {
        return HandlerFilterFunction.ofRequestProcessor(BeforeFilterFunctions.fallbackHeaders());
    }

    public static HandlerFilterFunction<ServerResponse, ServerResponse> fallbackHeaders(Consumer<BeforeFilterFunctions.FallbackHeadersConfig> configConsumer) {
        return HandlerFilterFunction.ofRequestProcessor(BeforeFilterFunctions.fallbackHeaders(configConsumer));
    }

    @Shortcut
    public static HandlerFilterFunction<ServerResponse, ServerResponse> mapRequestHeader(String fromHeader, String toHeader) {
        return HandlerFilterFunction.ofRequestProcessor(BeforeFilterFunctions.mapRequestHeader(fromHeader, toHeader));
    }

    @Shortcut
    public static HandlerFilterFunction<ServerResponse, ServerResponse> prefixPath(String prefix) {
        return HandlerFilterFunction.ofRequestProcessor(BeforeFilterFunctions.prefixPath(prefix));
    }

    @Shortcut
    public static HandlerFilterFunction<ServerResponse, ServerResponse> preserveHost() {
        return HandlerFilterFunction.ofRequestProcessor(BeforeFilterFunctions.preserveHostHeader());
    }

    public static HandlerFilterFunction<ServerResponse, ServerResponse> redirectTo(int status, URI uri) {
        return FilterFunctions.redirectTo(new HttpStatusHolder(null, status), uri);
    }

    public static HandlerFilterFunction<ServerResponse, ServerResponse> redirectTo(String status, URI uri) {
        return FilterFunctions.redirectTo(HttpStatusHolder.valueOf(status), uri);
    }

    public static HandlerFilterFunction<ServerResponse, ServerResponse> redirectTo(HttpStatusCode status, URI uri) {
        return FilterFunctions.redirectTo(new HttpStatusHolder(status, null), uri);
    }

    @Shortcut
    public static HandlerFilterFunction<ServerResponse, ServerResponse> redirectTo(HttpStatusHolder status, URI uri) {
        Assert.isTrue((boolean)status.is3xxRedirection(), (String)("status must be a 3xx code, but was " + status));
        return (request, next) -> ((ServerResponse.BodyBuilder)ServerResponse.status((HttpStatusCode)status.resolve()).header("Location", new String[]{uri.toString()})).build();
    }

    @Shortcut
    public static HandlerFilterFunction<ServerResponse, ServerResponse> removeRequestHeader(String name) {
        return HandlerFilterFunction.ofRequestProcessor(BeforeFilterFunctions.removeRequestHeader(name));
    }

    @Shortcut
    public static HandlerFilterFunction<ServerResponse, ServerResponse> removeRequestParameter(String name) {
        return HandlerFilterFunction.ofRequestProcessor(BeforeFilterFunctions.removeRequestParameter(name));
    }

    @Shortcut
    public static HandlerFilterFunction<ServerResponse, ServerResponse> removeResponseHeader(String name) {
        return HandlerFilterFunction.ofResponseProcessor(AfterFilterFunctions.removeResponseHeader(name));
    }

    @Shortcut
    public static HandlerFilterFunction<ServerResponse, ServerResponse> requestHeaderSize(String maxSize) {
        return HandlerFilterFunction.ofRequestProcessor(BeforeFilterFunctions.requestHeaderSize(maxSize));
    }

    public static HandlerFilterFunction<ServerResponse, ServerResponse> requestHeaderSize(DataSize maxSize) {
        return HandlerFilterFunction.ofRequestProcessor(BeforeFilterFunctions.requestHeaderSize(maxSize));
    }

    @Shortcut
    public static HandlerFilterFunction<ServerResponse, ServerResponse> requestHeaderToRequestUri(String name) {
        return HandlerFilterFunction.ofRequestProcessor(BeforeFilterFunctions.requestHeaderToRequestUri(name));
    }

    @Shortcut
    public static HandlerFilterFunction<ServerResponse, ServerResponse> requestSize(String maxSize) {
        return HandlerFilterFunction.ofRequestProcessor(BeforeFilterFunctions.requestSize(maxSize));
    }

    public static HandlerFilterFunction<ServerResponse, ServerResponse> requestSize(DataSize maxSize) {
        return HandlerFilterFunction.ofRequestProcessor(BeforeFilterFunctions.requestSize(maxSize));
    }

    @Shortcut
    public static HandlerFilterFunction<ServerResponse, ServerResponse> rewriteLocationResponseHeader(String stripVersion, String locationHeaderName, String hostValue, String protocolsRegex) {
        return HandlerFilterFunction.ofResponseProcessor(RewriteLocationResponseHeaderFilterFunctions.rewriteLocationResponseHeader(config -> config.setStripVersion(stripVersion).setLocationHeaderName(locationHeaderName).setHostValue(hostValue).setProtocolsRegex(protocolsRegex)));
    }

    @Shortcut
    public static HandlerFilterFunction<ServerResponse, ServerResponse> rewritePath(String regexp, String replacement) {
        return HandlerFilterFunction.ofRequestProcessor(BeforeFilterFunctions.rewritePath(regexp, replacement));
    }

    @Shortcut
    public static HandlerFilterFunction<ServerResponse, ServerResponse> rewriteResponseHeader(String name, String regexp, String replacement) {
        return HandlerFilterFunction.ofResponseProcessor(AfterFilterFunctions.rewriteResponseHeader(name, regexp, replacement));
    }

    @Shortcut
    public static HandlerFilterFunction<ServerResponse, ServerResponse> routeId(String routeId) {
        return HandlerFilterFunction.ofRequestProcessor(BeforeFilterFunctions.routeId(routeId));
    }

    @Shortcut
    public static HandlerFilterFunction<ServerResponse, ServerResponse> setPath(String path) {
        return HandlerFilterFunction.ofRequestProcessor(BeforeFilterFunctions.setPath(path));
    }

    @Shortcut
    public static HandlerFilterFunction<ServerResponse, ServerResponse> setRequestHeader(String name, String value) {
        return HandlerFilterFunction.ofRequestProcessor(BeforeFilterFunctions.setRequestHeader(name, value));
    }

    @Shortcut
    public static HandlerFilterFunction<ServerResponse, ServerResponse> setRequestHostHeader(String host) {
        return HandlerFilterFunction.ofRequestProcessor(BeforeFilterFunctions.setRequestHostHeader(host));
    }

    @Shortcut
    public static HandlerFilterFunction<ServerResponse, ServerResponse> setResponseHeader(String name, String value) {
        return HandlerFilterFunction.ofResponseProcessor(AfterFilterFunctions.setResponseHeader(name, value));
    }

    public static HandlerFilterFunction<ServerResponse, ServerResponse> stripPrefix() {
        return FilterFunctions.stripPrefix(1);
    }

    @Shortcut
    public static HandlerFilterFunction<ServerResponse, ServerResponse> stripPrefix(int parts) {
        return HandlerFilterFunction.ofRequestProcessor(BeforeFilterFunctions.stripPrefix(parts));
    }

    public static HandlerFilterFunction<ServerResponse, ServerResponse> setStatus(int statusCode) {
        return FilterFunctions.setStatus(new HttpStatusHolder(null, statusCode));
    }

    public static HandlerFilterFunction<ServerResponse, ServerResponse> setStatus(HttpStatusCode statusCode) {
        return FilterFunctions.setStatus(new HttpStatusHolder(statusCode, null));
    }

    @Shortcut
    public static HandlerFilterFunction<ServerResponse, ServerResponse> setStatus(HttpStatusHolder statusCode) {
        return HandlerFilterFunction.ofResponseProcessor(AfterFilterFunctions.setStatus(statusCode));
    }

    public static class FilterSupplier
    extends SimpleFilterSupplier {
        public FilterSupplier() {
            super(FilterFunctions.class);
        }
    }
}

