/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.autoconfigure.actuate.observability;

import io.micrometer.tracing.Tracer;
import java.util.List;
import java.util.Objects;
import org.springframework.aot.AotDetector;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.boot.test.autoconfigure.actuate.observability.AutoConfigureObservability;
import org.springframework.boot.test.util.TestPropertyValues;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.Ordered;
import org.springframework.core.env.Environment;
import org.springframework.test.context.ContextConfigurationAttributes;
import org.springframework.test.context.ContextCustomizer;
import org.springframework.test.context.ContextCustomizerFactory;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.test.context.TestContextAnnotationUtils;
import org.springframework.util.ClassUtils;

class ObservabilityContextCustomizerFactory
implements ContextCustomizerFactory {
    static final String AUTO_CONFIGURE_PROPERTY = "spring.test.observability.auto-configure";

    ObservabilityContextCustomizerFactory() {
    }

    public ContextCustomizer createContextCustomizer(Class<?> testClass, List<ContextConfigurationAttributes> configAttributes) {
        AutoConfigureObservability annotation = (AutoConfigureObservability)TestContextAnnotationUtils.findMergedAnnotation(testClass, AutoConfigureObservability.class);
        return new DisableObservabilityContextCustomizer(annotation);
    }

    private static class DisableObservabilityContextCustomizer
    implements ContextCustomizer {
        private final AutoConfigureObservability annotation;

        DisableObservabilityContextCustomizer(AutoConfigureObservability annotation) {
            this.annotation = annotation;
        }

        public void customizeContext(ConfigurableApplicationContext context, MergedContextConfiguration mergedContextConfiguration) {
            if (this.areMetricsDisabled((Environment)context.getEnvironment())) {
                TestPropertyValues.of((String[])new String[]{"management.defaults.metrics.export.enabled=false", "management.simple.metrics.export.enabled=true"}).applyTo(context);
            }
            if (this.isTracingDisabled((Environment)context.getEnvironment())) {
                TestPropertyValues.of((String[])new String[]{"management.tracing.enabled=false"}).applyTo(context);
                this.registerNoopTracer(context);
            }
        }

        private boolean areMetricsDisabled(Environment environment) {
            if (this.annotation != null) {
                return !this.annotation.metrics();
            }
            return (Boolean)environment.getProperty(ObservabilityContextCustomizerFactory.AUTO_CONFIGURE_PROPERTY, Boolean.class, (Object)false) == false;
        }

        private boolean isTracingDisabled(Environment environment) {
            if (this.annotation != null) {
                return !this.annotation.tracing();
            }
            return (Boolean)environment.getProperty(ObservabilityContextCustomizerFactory.AUTO_CONFIGURE_PROPERTY, Boolean.class, (Object)false) == false;
        }

        private void registerNoopTracer(ConfigurableApplicationContext context) {
            if (AotDetector.useGeneratedArtifacts()) {
                return;
            }
            if (!ClassUtils.isPresent((String)"io.micrometer.tracing.Tracer", (ClassLoader)context.getClassLoader())) {
                return;
            }
            ConfigurableListableBeanFactory beanFactory = context.getBeanFactory();
            if (beanFactory instanceof BeanDefinitionRegistry) {
                BeanDefinitionRegistry registry = (BeanDefinitionRegistry)beanFactory;
                this.registerNoopTracer(registry);
            }
        }

        private void registerNoopTracer(BeanDefinitionRegistry registry) {
            RootBeanDefinition definition = new RootBeanDefinition(NoopTracerRegistrar.class);
            definition.setRole(2);
            registry.registerBeanDefinition(NoopTracerRegistrar.class.getName(), (BeanDefinition)definition);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DisableObservabilityContextCustomizer that = (DisableObservabilityContextCustomizer)o;
            return Objects.equals(this.annotation, that.annotation);
        }

        public int hashCode() {
            return Objects.hash(this.annotation);
        }
    }

    static class NoopTracerFactoryBean
    implements FactoryBean<Tracer> {
        NoopTracerFactoryBean() {
        }

        public Tracer getObject() {
            return Tracer.NOOP;
        }

        public Class<?> getObjectType() {
            return Tracer.class;
        }
    }

    static class NoopTracerRegistrar
    implements BeanDefinitionRegistryPostProcessor,
    Ordered,
    BeanFactoryAware {
        private BeanFactory beanFactory;

        NoopTracerRegistrar() {
        }

        public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
            this.beanFactory = beanFactory;
        }

        public int getOrder() {
            return Integer.MAX_VALUE;
        }

        public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
            if (AotDetector.useGeneratedArtifacts()) {
                return;
            }
            if (BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)((ListableBeanFactory)this.beanFactory), Tracer.class, (boolean)false, (boolean)false).length == 0) {
                registry.registerBeanDefinition("noopTracer", (BeanDefinition)new RootBeanDefinition(NoopTracerFactoryBean.class));
            }
        }

        public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        }
    }
}

