/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.autoconfigure.web.client;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.time.Duration;
import java.util.Map;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.test.web.client.MockServerRestTemplateCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.test.web.client.ExpectedCount;
import org.springframework.test.web.client.MockRestServiceServer;
import org.springframework.test.web.client.RequestExpectationManager;
import org.springframework.test.web.client.RequestMatcher;
import org.springframework.test.web.client.ResponseActions;
import org.springframework.util.Assert;

@AutoConfiguration
@ConditionalOnProperty(prefix="spring.test.webclient.mockrestserviceserver", name={"enabled"})
public class MockRestServiceServerAutoConfiguration {
    @Bean
    public MockServerRestTemplateCustomizer mockServerRestTemplateCustomizer() {
        return new MockServerRestTemplateCustomizer();
    }

    @Bean
    public MockRestServiceServer mockRestServiceServer(MockServerRestTemplateCustomizer customizer) {
        try {
            return this.createDeferredMockRestServiceServer(customizer);
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    private MockRestServiceServer createDeferredMockRestServiceServer(MockServerRestTemplateCustomizer customizer) throws Exception {
        Constructor constructor = MockRestServiceServer.class.getDeclaredConstructor(RequestExpectationManager.class);
        constructor.setAccessible(true);
        return (MockRestServiceServer)constructor.newInstance(new DeferredRequestExpectationManager(customizer));
    }

    private static class DeferredRequestExpectationManager
    implements RequestExpectationManager {
        private MockServerRestTemplateCustomizer customizer;

        DeferredRequestExpectationManager(MockServerRestTemplateCustomizer customizer) {
            this.customizer = customizer;
        }

        public ResponseActions expectRequest(ExpectedCount count, RequestMatcher requestMatcher) {
            return this.getDelegate().expectRequest(count, requestMatcher);
        }

        public ClientHttpResponse validateRequest(ClientHttpRequest request) throws IOException {
            return this.getDelegate().validateRequest(request);
        }

        public void verify() {
            this.getDelegate().verify();
        }

        public void verify(Duration timeout) {
            this.getDelegate().verify(timeout);
        }

        public void reset() {
            Map expectationManagers = this.customizer.getExpectationManagers();
            if (expectationManagers.size() == 1) {
                this.getDelegate().reset();
            }
        }

        private RequestExpectationManager getDelegate() {
            Map expectationManagers = this.customizer.getExpectationManagers();
            Assert.state((!expectationManagers.isEmpty() ? 1 : 0) != 0, (String)"Unable to use auto-configured MockRestServiceServer since MockServerRestTemplateCustomizer has not been bound to a RestTemplate");
            Assert.state((expectationManagers.size() == 1 ? 1 : 0) != 0, (String)"Unable to use auto-configured MockRestServiceServer since MockServerRestTemplateCustomizer has been bound to more than one RestTemplate");
            return (RequestExpectationManager)expectationManagers.values().iterator().next();
        }
    }
}

