/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.buildpack.platform.docker.type;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.util.List;
import org.springframework.boot.buildpack.platform.docker.type.BlobReference;
import org.springframework.boot.buildpack.platform.json.MappedObject;
import org.springframework.util.Assert;

public class ImageArchiveIndex
extends MappedObject {
    private final Integer schemaVersion = this.extractSchemaVersion();
    private final List<BlobReference> manifests = this.childrenAt("/manifests", BlobReference::new);

    protected ImageArchiveIndex(JsonNode node) {
        super(node, MethodHandles.lookup());
    }

    private Integer extractSchemaVersion() {
        Integer result = this.valueAt("/schemaVersion", Integer.class);
        Assert.state((result != null ? 1 : 0) != 0, (String)"'result' must not be null");
        return result;
    }

    public Integer getSchemaVersion() {
        return this.schemaVersion;
    }

    public List<BlobReference> getManifests() {
        return this.manifests;
    }

    public static ImageArchiveIndex of(InputStream content) throws IOException {
        return ImageArchiveIndex.of(content, ImageArchiveIndex::new);
    }
}

