/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.buildpack.platform.docker.configuration;

import com.fasterxml.jackson.databind.JsonNode;
import java.lang.invoke.MethodHandles;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.buildpack.platform.json.MappedObject;
import org.springframework.util.Assert;

class Credential
extends MappedObject {
    private static final String TOKEN_USERNAME = "<token>";
    private final String username = this.extractUsername();
    private final String secret = this.extractSecret();
    private final @Nullable String serverUrl = this.valueAt("/ServerURL", String.class);

    Credential(JsonNode node) {
        super(node, MethodHandles.lookup());
    }

    private String extractSecret() {
        String result = this.valueAt("/Secret", String.class);
        Assert.state((result != null ? 1 : 0) != 0, (String)"'result' must not be null");
        return result;
    }

    private String extractUsername() {
        String result = this.valueAt("/Username", String.class);
        Assert.state((result != null ? 1 : 0) != 0, (String)"'result' must not be null");
        return result;
    }

    String getUsername() {
        return this.username;
    }

    String getSecret() {
        return this.secret;
    }

    @Nullable String getServerUrl() {
        return this.serverUrl;
    }

    boolean isIdentityToken() {
        return TOKEN_USERNAME.equals(this.username);
    }
}

