/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.mcp.client.common.autoconfigure.annotations;

import java.lang.annotation.Annotation;
import java.util.Set;
import org.springaicommunity.mcp.annotation.McpElicitation;
import org.springaicommunity.mcp.annotation.McpLogging;
import org.springaicommunity.mcp.annotation.McpProgress;
import org.springaicommunity.mcp.annotation.McpSampling;
import org.springframework.ai.mcp.annotation.spring.scan.AbstractAnnotatedMethodBeanPostProcessor;
import org.springframework.ai.mcp.annotation.spring.scan.AbstractMcpAnnotatedBeans;
import org.springframework.ai.mcp.client.common.autoconfigure.annotations.McpClientAnnotationScannerProperties;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@ConditionalOnClass(value={McpLogging.class})
@ConditionalOnProperty(prefix="spring.ai.mcp.client.annotation-scanner", name={"enabled"}, havingValue="true", matchIfMissing=true)
@EnableConfigurationProperties(value={McpClientAnnotationScannerProperties.class})
public class McpClientAnnotationScannerAutoConfiguration {
    private static final Set<Class<? extends Annotation>> CLIENT_MCP_ANNOTATIONS = Set.of(McpLogging.class, McpSampling.class, McpElicitation.class, McpProgress.class);

    @Bean
    @ConditionalOnMissingBean
    public ClientMcpAnnotatedBeans clientAnnotatedBeans() {
        return new ClientMcpAnnotatedBeans();
    }

    @Bean
    @ConditionalOnMissingBean
    public ClientAnnotatedMethodBeanPostProcessor clientAnnotatedMethodBeanPostProcessor(ClientMcpAnnotatedBeans clientMcpAnnotatedBeans, McpClientAnnotationScannerProperties properties) {
        return new ClientAnnotatedMethodBeanPostProcessor(clientMcpAnnotatedBeans, CLIENT_MCP_ANNOTATIONS);
    }

    public static class ClientMcpAnnotatedBeans
    extends AbstractMcpAnnotatedBeans {
    }

    public static class ClientAnnotatedMethodBeanPostProcessor
    extends AbstractAnnotatedMethodBeanPostProcessor {
        public ClientAnnotatedMethodBeanPostProcessor(ClientMcpAnnotatedBeans clientMcpAnnotatedBeans, Set<Class<? extends Annotation>> targetAnnotations) {
            super((AbstractMcpAnnotatedBeans)clientMcpAnnotatedBeans, targetAnnotations);
        }
    }
}

