/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.develop.support;

import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.generator.FastAutoGenerator;
import com.baomidou.mybatisplus.generator.config.OutputFile;
import com.baomidou.mybatisplus.generator.config.TemplateType;
import com.baomidou.mybatisplus.generator.config.builder.CustomFile;
import com.baomidou.mybatisplus.generator.config.po.TableInfo;
import com.baomidou.mybatisplus.generator.config.rules.DateType;
import com.baomidou.mybatisplus.generator.config.rules.NamingStrategy;
import com.baomidou.mybatisplus.generator.engine.AbstractTemplateEngine;
import com.baomidou.mybatisplus.generator.engine.VelocityTemplateEngine;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import lombok.Generated;
import org.apache.ibatis.annotations.Mapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springblade.core.tool.utils.Func;
import org.springblade.core.tool.utils.StringUtil;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PropertiesLoaderUtils;

public class BladeCodeGenerator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BladeCodeGenerator.class);
    private String systemName = "saber3";
    private String codeName;
    private String serviceName = "blade-service";
    private String packageName = "org.springblade.test";
    private String packageDir;
    private String packageWebDir;
    private String[] tablePrefix = new String[]{"blade_"};
    private String[] includeTables = new String[]{"blade_test"};
    private String[] excludeTables = new String[0];
    private Boolean hasSuperEntity = Boolean.TRUE;
    private Boolean hasWrapper = Boolean.TRUE;
    private Boolean hasServiceName = Boolean.FALSE;
    private String[] superEntityColumns = new String[]{"create_time", "create_user", "create_dept", "update_time", "update_user", "status", "is_deleted"};
    private String tenantColumn = "tenant_id";
    private String driverName;
    private String url;
    private String username;
    private String password;

    public void run() {
        Properties props = this.getProperties();
        String url = Func.toStr((Object)this.url, (String)props.getProperty("spring.datasource.url"));
        String username = Func.toStr((Object)this.username, (String)props.getProperty("spring.datasource.username"));
        String password = Func.toStr((Object)this.password, (String)props.getProperty("spring.datasource.password"));
        final String servicePackage = this.serviceName.split("-").length > 1 ? this.serviceName.split("-")[1] : this.serviceName;
        HashMap<String, Object> customMap = new HashMap<String, Object>(11);
        customMap.put("codeName", this.codeName);
        customMap.put("serviceName", this.serviceName);
        customMap.put("servicePackage", servicePackage);
        customMap.put("servicePackageLowerCase", servicePackage.toLowerCase());
        customMap.put("tenantColumn", this.tenantColumn);
        customMap.put("hasWrapper", this.hasWrapper);
        customMap.put("hasServiceName", this.hasServiceName);
        HashMap<String, String> customFile = new HashMap<String, String>(15);
        customFile.put("menu.sql", "/templates/sql/menu.sql.vm");
        customFile.put("entityVO.java", "/templates/entityVO.java.vm");
        customFile.put("entityDTO.java", "/templates/entityDTO.java.vm");
        if (this.hasWrapper.booleanValue()) {
            customFile.put("wrapper.java", "/templates/wrapper.java.vm");
        }
        if (Func.isNotBlank((CharSequence)this.packageWebDir)) {
            if (Func.equals((Object)this.systemName, (Object)"sword")) {
                customFile.put("action.js", "/templates/sword/action.js.vm");
                customFile.put("model.js", "/templates/sword/model.js.vm");
                customFile.put("service.js", "/templates/sword/service.js.vm");
                customFile.put("list.js", "/templates/sword/list.js.vm");
                customFile.put("add.js", "/templates/sword/add.js.vm");
                customFile.put("edit.js", "/templates/sword/edit.js.vm");
                customFile.put("view.js", "/templates/sword/view.js.vm");
            } else if (Func.equals((Object)this.systemName, (Object)"saber")) {
                customFile.put("api.js", "/templates/saber/api.js.vm");
                customFile.put("crud.vue", "/templates/saber/crud.vue.vm");
            } else if (Func.equals((Object)this.systemName, (Object)"saber3")) {
                customFile.put("api.js", "/templates/saber3/api.js.vm");
                customFile.put("crud.vue", "/templates/saber3/crud.vue.vm");
            }
        }
        FastAutoGenerator.create((String)url, (String)username, (String)password).globalConfig(builder -> builder.author(props.getProperty("author")).dateType(DateType.TIME_PACK).enableSwagger().outputDir(this.getOutputDir()).disableOpenDir()).packageConfig(builder -> builder.parent(this.packageName).controller("controller").entity("entity").service("service").serviceImpl("service.impl").mapper("mapper").xml("mapper")).strategyConfig(builder -> builder.addTablePrefix(this.tablePrefix).addInclude(this.includeTables).addExclude(this.excludeTables).entityBuilder().naming(NamingStrategy.underline_to_camel).columnNaming(NamingStrategy.underline_to_camel).enableLombok().superClass("org.springblade.core.mp.base.BaseEntity").addSuperEntityColumns(this.superEntityColumns).enableFileOverride().serviceBuilder().superServiceClass("org.springblade.core.mp.base.BaseService").superServiceImplClass("org.springblade.core.mp.base.BaseServiceImpl").formatServiceFileName("I%sService").formatServiceImplFileName("%sServiceImpl").enableFileOverride().mapperBuilder().mapperAnnotation(Mapper.class).enableBaseResultMap().enableBaseColumnList().formatMapperFileName("%sMapper").formatXmlFileName("%sMapper").enableFileOverride().controllerBuilder().superClass("org.springblade.core.boot.ctrl.BladeController").formatFileName("%sController").enableRestStyle().enableHyphenStyle().enableFileOverride()).templateConfig(builder -> builder.disable(new TemplateType[]{TemplateType.ENTITY}).entity("/templates/entity.java.vm").service("/templates/service.java.vm").serviceImpl("/templates/serviceImpl.java.vm").mapper("/templates/mapper.java.vm").xml("/templates/mapper.xml.vm").controller("/templates/controller.java.vm")).injectionConfig(builder -> builder.beforeOutputFile((tableInfo, objectMap) -> System.out.println("tableInfo: " + tableInfo.getEntityName() + " objectMap: " + objectMap.size())).customMap(customMap).customFile(customFile)).templateEngine((AbstractTemplateEngine)new VelocityTemplateEngine(){

            protected void outputCustomFile(List<CustomFile> customFiles, TableInfo tableInfo, Map<String, Object> objectMap) {
                String entityName = tableInfo.getEntityName();
                String entityNameLower = tableInfo.getEntityName().toLowerCase();
                customFiles.forEach(customFile -> {
                    String key = customFile.getFileName();
                    String value = customFile.getTemplatePath();
                    Object outputPath = this.getPathInfo(OutputFile.parent);
                    objectMap.put("entityKey", entityNameLower);
                    if (StringUtil.equals((CharSequence)key, (CharSequence)"menu.sql")) {
                        objectMap.put("menuId", IdWorker.getId());
                        objectMap.put("addMenuId", IdWorker.getId());
                        objectMap.put("editMenuId", IdWorker.getId());
                        objectMap.put("removeMenuId", IdWorker.getId());
                        objectMap.put("viewMenuId", IdWorker.getId());
                        outputPath = BladeCodeGenerator.this.getOutputDir() + "/sql/" + entityNameLower + ".menu.sql";
                    }
                    if (StringUtil.equals((CharSequence)key, (CharSequence)"entityVO.java")) {
                        outputPath = BladeCodeGenerator.this.getOutputDir() + "/" + BladeCodeGenerator.this.packageName.replace(".", "/") + "/vo/" + entityName + "VO.java";
                    }
                    if (StringUtil.equals((CharSequence)key, (CharSequence)"entityDTO.java")) {
                        outputPath = BladeCodeGenerator.this.getOutputDir() + "/" + BladeCodeGenerator.this.packageName.replace(".", "/") + "/dto/" + entityName + "DTO.java";
                    }
                    if (StringUtil.equals((CharSequence)key, (CharSequence)"wrapper.java")) {
                        outputPath = BladeCodeGenerator.this.getOutputDir() + "/" + BladeCodeGenerator.this.packageName.replace(".", "/") + "/wrapper/" + entityName + "Wrapper.java";
                    }
                    if (StringUtil.equals((CharSequence)key, (CharSequence)"action.js")) {
                        outputPath = BladeCodeGenerator.this.getOutputWebDir() + "/actions/" + entityNameLower + ".js";
                    }
                    if (StringUtil.equals((CharSequence)key, (CharSequence)"model.js")) {
                        outputPath = BladeCodeGenerator.this.getOutputWebDir() + "/models/" + entityNameLower + ".js";
                    }
                    if (StringUtil.equals((CharSequence)key, (CharSequence)"service.js")) {
                        outputPath = BladeCodeGenerator.this.getOutputWebDir() + "/services/" + entityNameLower + ".js";
                    }
                    if (StringUtil.equals((CharSequence)key, (CharSequence)"list.js")) {
                        outputPath = BladeCodeGenerator.this.getOutputWebDir() + "/pages/" + StringUtil.upperFirst((String)servicePackage) + "/" + entityName + "/" + entityName + ".js";
                    }
                    if (StringUtil.equals((CharSequence)key, (CharSequence)"add.js")) {
                        outputPath = BladeCodeGenerator.this.getOutputWebDir() + "/pages/" + StringUtil.upperFirst((String)servicePackage) + "/" + entityName + "/" + entityName + "Add.js";
                    }
                    if (StringUtil.equals((CharSequence)key, (CharSequence)"edit.js")) {
                        outputPath = BladeCodeGenerator.this.getOutputWebDir() + "/pages/" + StringUtil.upperFirst((String)servicePackage) + "/" + entityName + "/" + entityName + "Edit.js";
                    }
                    if (StringUtil.equals((CharSequence)key, (CharSequence)"view.js")) {
                        outputPath = BladeCodeGenerator.this.getOutputWebDir() + "/pages/" + StringUtil.upperFirst((String)servicePackage) + "/" + entityName + "/" + entityName + "View.js";
                    }
                    if (StringUtil.equals((CharSequence)key, (CharSequence)"api.js")) {
                        outputPath = BladeCodeGenerator.this.getOutputWebDir() + "/api/" + servicePackage.toLowerCase() + "/" + entityNameLower + ".js";
                    }
                    if (StringUtil.equals((CharSequence)key, (CharSequence)"crud.vue")) {
                        outputPath = BladeCodeGenerator.this.getOutputWebDir() + "/views/" + servicePackage.toLowerCase() + "/" + entityNameLower + ".vue";
                    }
                    this.outputFile(new File(String.valueOf(outputPath)), objectMap, value, Boolean.TRUE);
                });
            }
        }).execute();
    }

    private Properties getProperties() {
        ClassPathResource resource = new ClassPathResource("/templates/code.properties");
        Properties props = new Properties();
        try {
            props = PropertiesLoaderUtils.loadProperties((Resource)resource);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return props;
    }

    public String getOutputDir() {
        return (String)(Func.isBlank((CharSequence)this.packageDir) ? System.getProperty("user.dir") + "/blade-ops/blade-develop" : this.packageDir) + "/src/main/java";
    }

    public String getOutputWebDir() {
        return (Func.isBlank((CharSequence)this.packageWebDir) ? System.getProperty("user.dir") : this.packageWebDir) + "/src";
    }

    @Generated
    public BladeCodeGenerator() {
    }

    @Generated
    public String getSystemName() {
        return this.systemName;
    }

    @Generated
    public String getCodeName() {
        return this.codeName;
    }

    @Generated
    public String getServiceName() {
        return this.serviceName;
    }

    @Generated
    public String getPackageName() {
        return this.packageName;
    }

    @Generated
    public String getPackageDir() {
        return this.packageDir;
    }

    @Generated
    public String getPackageWebDir() {
        return this.packageWebDir;
    }

    @Generated
    public String[] getTablePrefix() {
        return this.tablePrefix;
    }

    @Generated
    public String[] getIncludeTables() {
        return this.includeTables;
    }

    @Generated
    public String[] getExcludeTables() {
        return this.excludeTables;
    }

    @Generated
    public Boolean getHasSuperEntity() {
        return this.hasSuperEntity;
    }

    @Generated
    public Boolean getHasWrapper() {
        return this.hasWrapper;
    }

    @Generated
    public Boolean getHasServiceName() {
        return this.hasServiceName;
    }

    @Generated
    public String[] getSuperEntityColumns() {
        return this.superEntityColumns;
    }

    @Generated
    public String getTenantColumn() {
        return this.tenantColumn;
    }

    @Generated
    public String getDriverName() {
        return this.driverName;
    }

    @Generated
    public String getUrl() {
        return this.url;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public void setSystemName(String systemName) {
        this.systemName = systemName;
    }

    @Generated
    public void setCodeName(String codeName) {
        this.codeName = codeName;
    }

    @Generated
    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    @Generated
    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    @Generated
    public void setPackageDir(String packageDir) {
        this.packageDir = packageDir;
    }

    @Generated
    public void setPackageWebDir(String packageWebDir) {
        this.packageWebDir = packageWebDir;
    }

    @Generated
    public void setTablePrefix(String[] tablePrefix) {
        this.tablePrefix = tablePrefix;
    }

    @Generated
    public void setIncludeTables(String[] includeTables) {
        this.includeTables = includeTables;
    }

    @Generated
    public void setExcludeTables(String[] excludeTables) {
        this.excludeTables = excludeTables;
    }

    @Generated
    public void setHasSuperEntity(Boolean hasSuperEntity) {
        this.hasSuperEntity = hasSuperEntity;
    }

    @Generated
    public void setHasWrapper(Boolean hasWrapper) {
        this.hasWrapper = hasWrapper;
    }

    @Generated
    public void setHasServiceName(Boolean hasServiceName) {
        this.hasServiceName = hasServiceName;
    }

    @Generated
    public void setSuperEntityColumns(String[] superEntityColumns) {
        this.superEntityColumns = superEntityColumns;
    }

    @Generated
    public void setTenantColumn(String tenantColumn) {
        this.tenantColumn = tenantColumn;
    }

    @Generated
    public void setDriverName(String driverName) {
        this.driverName = driverName;
    }

    @Generated
    public void setUrl(String url) {
        this.url = url;
    }

    @Generated
    public void setUsername(String username) {
        this.username = username;
    }

    @Generated
    public void setPassword(String password) {
        this.password = password;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BladeCodeGenerator)) {
            return false;
        }
        BladeCodeGenerator other = (BladeCodeGenerator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$hasSuperEntity = this.getHasSuperEntity();
        Boolean other$hasSuperEntity = other.getHasSuperEntity();
        if (this$hasSuperEntity == null ? other$hasSuperEntity != null : !((Object)this$hasSuperEntity).equals(other$hasSuperEntity)) {
            return false;
        }
        Boolean this$hasWrapper = this.getHasWrapper();
        Boolean other$hasWrapper = other.getHasWrapper();
        if (this$hasWrapper == null ? other$hasWrapper != null : !((Object)this$hasWrapper).equals(other$hasWrapper)) {
            return false;
        }
        Boolean this$hasServiceName = this.getHasServiceName();
        Boolean other$hasServiceName = other.getHasServiceName();
        if (this$hasServiceName == null ? other$hasServiceName != null : !((Object)this$hasServiceName).equals(other$hasServiceName)) {
            return false;
        }
        String this$systemName = this.getSystemName();
        String other$systemName = other.getSystemName();
        if (this$systemName == null ? other$systemName != null : !this$systemName.equals(other$systemName)) {
            return false;
        }
        String this$codeName = this.getCodeName();
        String other$codeName = other.getCodeName();
        if (this$codeName == null ? other$codeName != null : !this$codeName.equals(other$codeName)) {
            return false;
        }
        String this$serviceName = this.getServiceName();
        String other$serviceName = other.getServiceName();
        if (this$serviceName == null ? other$serviceName != null : !this$serviceName.equals(other$serviceName)) {
            return false;
        }
        String this$packageName = this.getPackageName();
        String other$packageName = other.getPackageName();
        if (this$packageName == null ? other$packageName != null : !this$packageName.equals(other$packageName)) {
            return false;
        }
        String this$packageDir = this.getPackageDir();
        String other$packageDir = other.getPackageDir();
        if (this$packageDir == null ? other$packageDir != null : !this$packageDir.equals(other$packageDir)) {
            return false;
        }
        String this$packageWebDir = this.getPackageWebDir();
        String other$packageWebDir = other.getPackageWebDir();
        if (this$packageWebDir == null ? other$packageWebDir != null : !this$packageWebDir.equals(other$packageWebDir)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getTablePrefix(), other.getTablePrefix())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getIncludeTables(), other.getIncludeTables())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getExcludeTables(), other.getExcludeTables())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getSuperEntityColumns(), other.getSuperEntityColumns())) {
            return false;
        }
        String this$tenantColumn = this.getTenantColumn();
        String other$tenantColumn = other.getTenantColumn();
        if (this$tenantColumn == null ? other$tenantColumn != null : !this$tenantColumn.equals(other$tenantColumn)) {
            return false;
        }
        String this$driverName = this.getDriverName();
        String other$driverName = other.getDriverName();
        if (this$driverName == null ? other$driverName != null : !this$driverName.equals(other$driverName)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        return !(this$password == null ? other$password != null : !this$password.equals(other$password));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BladeCodeGenerator;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $hasSuperEntity = this.getHasSuperEntity();
        result = result * 59 + ($hasSuperEntity == null ? 43 : ((Object)$hasSuperEntity).hashCode());
        Boolean $hasWrapper = this.getHasWrapper();
        result = result * 59 + ($hasWrapper == null ? 43 : ((Object)$hasWrapper).hashCode());
        Boolean $hasServiceName = this.getHasServiceName();
        result = result * 59 + ($hasServiceName == null ? 43 : ((Object)$hasServiceName).hashCode());
        String $systemName = this.getSystemName();
        result = result * 59 + ($systemName == null ? 43 : $systemName.hashCode());
        String $codeName = this.getCodeName();
        result = result * 59 + ($codeName == null ? 43 : $codeName.hashCode());
        String $serviceName = this.getServiceName();
        result = result * 59 + ($serviceName == null ? 43 : $serviceName.hashCode());
        String $packageName = this.getPackageName();
        result = result * 59 + ($packageName == null ? 43 : $packageName.hashCode());
        String $packageDir = this.getPackageDir();
        result = result * 59 + ($packageDir == null ? 43 : $packageDir.hashCode());
        String $packageWebDir = this.getPackageWebDir();
        result = result * 59 + ($packageWebDir == null ? 43 : $packageWebDir.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getTablePrefix());
        result = result * 59 + Arrays.deepHashCode(this.getIncludeTables());
        result = result * 59 + Arrays.deepHashCode(this.getExcludeTables());
        result = result * 59 + Arrays.deepHashCode(this.getSuperEntityColumns());
        String $tenantColumn = this.getTenantColumn();
        result = result * 59 + ($tenantColumn == null ? 43 : $tenantColumn.hashCode());
        String $driverName = this.getDriverName();
        result = result * 59 + ($driverName == null ? 43 : $driverName.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "BladeCodeGenerator(systemName=" + this.getSystemName() + ", codeName=" + this.getCodeName() + ", serviceName=" + this.getServiceName() + ", packageName=" + this.getPackageName() + ", packageDir=" + this.getPackageDir() + ", packageWebDir=" + this.getPackageWebDir() + ", tablePrefix=" + Arrays.deepToString(this.getTablePrefix()) + ", includeTables=" + Arrays.deepToString(this.getIncludeTables()) + ", excludeTables=" + Arrays.deepToString(this.getExcludeTables()) + ", hasSuperEntity=" + this.getHasSuperEntity() + ", hasWrapper=" + this.getHasWrapper() + ", hasServiceName=" + this.getHasServiceName() + ", superEntityColumns=" + Arrays.deepToString(this.getSuperEntityColumns()) + ", tenantColumn=" + this.getTenantColumn() + ", driverName=" + this.getDriverName() + ", url=" + this.getUrl() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ")";
    }
}

