/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.cloud.http.client;

import java.io.IOException;
import java.io.OutputStream;
import org.springframework.http.HttpHeaders;
import org.springframework.http.StreamingHttpOutputMessage;
import org.springframework.http.client.AbstractClientHttpRequest;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.FastByteArrayOutputStream;

public abstract class AbstractStreamingClientHttpRequest
extends AbstractClientHttpRequest
implements StreamingHttpOutputMessage {
    @Nullable
    private StreamingHttpOutputMessage.Body body;
    @Nullable
    private FastByteArrayOutputStream bodyStream;

    protected final OutputStream getBodyInternal(HttpHeaders headers) {
        Assert.state((this.body == null ? 1 : 0) != 0, (String)"Invoke either getBody or setBody; not both");
        if (this.bodyStream == null) {
            this.bodyStream = new FastByteArrayOutputStream(1024);
        }
        return this.bodyStream;
    }

    public final void setBody(StreamingHttpOutputMessage.Body body) {
        Assert.notNull((Object)body, (String)"Body must not be null");
        this.assertNotExecuted();
        Assert.state((this.bodyStream == null ? 1 : 0) != 0, (String)"Invoke either getBody or setBody; not both");
        this.body = body;
    }

    protected final ClientHttpResponse executeInternal(HttpHeaders headers) throws IOException {
        if (this.body == null && this.bodyStream != null) {
            this.body = outputStream -> this.bodyStream.writeTo(outputStream);
        }
        return this.executeInternal(headers, this.body);
    }

    protected abstract ClientHttpResponse executeInternal(HttpHeaders var1, @Nullable StreamingHttpOutputMessage.Body var2) throws IOException;
}

