/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.cloud.config;

import com.alibaba.cloud.sentinel.feign.SentinelFeignAutoConfiguration;
import com.alibaba.csp.sentinel.adapter.spring.webmvc_v6x.callback.BlockExceptionHandler;
import feign.Feign;
import feign.RequestInterceptor;
import org.springblade.core.cloud.config.BladeSentinelFilterConfiguration;
import org.springblade.core.cloud.feign.BladeFeignSentinel;
import org.springblade.core.cloud.header.BladeFeignRequestHeaderInterceptor;
import org.springblade.core.cloud.sentinel.BladeBlockExceptionHandler;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Scope;

@AutoConfiguration
@Import(value={BladeSentinelFilterConfiguration.class})
@AutoConfigureBefore(value={SentinelFeignAutoConfiguration.class})
public class BladeCloudAutoConfiguration {
    @Bean
    @Scope(value="prototype")
    @ConditionalOnMissingBean
    @ConditionalOnProperty(name={"feign.sentinel.enabled"})
    public Feign.Builder feignSentinelBuilder(RequestInterceptor requestInterceptor) {
        return BladeFeignSentinel.builder().requestInterceptor(requestInterceptor);
    }

    @Bean
    @ConditionalOnMissingBean
    public BlockExceptionHandler blockExceptionHandler() {
        return new BladeBlockExceptionHandler();
    }

    @Bean
    @ConditionalOnMissingBean
    public RequestInterceptor requestInterceptor() {
        return new BladeFeignRequestHeaderInterceptor();
    }
}

