/*
 * Decompiled with CFR 0.152.
 */
package org.phprpc.spring.remoting;

import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.phprpc.PHPRPC_Client;
import org.springframework.remoting.RemoteProxyFailureException;
import org.springframework.remoting.support.UrlBasedRemoteAccessor;

public class PHPRPC_ClientInterceptor
extends UrlBasedRemoteAccessor
implements MethodInterceptor {
    private PHPRPC_Client proxyFactory = null;
    private String proxy = null;
    private String charset = "utf-8";
    private int keyLength = 128;
    private int encryptMode = 0;
    private int timeout = 30000;
    private Object phprpcProxy = null;

    public void setWebProxy(String proxy) {
        this.proxy = proxy;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public void setKeyLength(int keyLength) {
        this.keyLength = keyLength;
    }

    public void setEncryptMode(int encryptMode) {
        this.encryptMode = encryptMode;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void setProxyFactory(PHPRPC_Client proxyFactory) {
        this.proxyFactory = proxyFactory;
    }

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        this.prepare();
    }

    public void prepare() {
        this.proxyFactory = new PHPRPC_Client(this.getServiceUrl());
        try {
            this.proxyFactory.setProxy(this.proxy);
        }
        catch (MalformedURLException ex) {
            this.proxy = null;
        }
        this.proxyFactory.setCharset(this.charset);
        this.proxyFactory.setKeyLength(this.keyLength);
        this.proxyFactory.setEncryptMode(this.encryptMode);
        this.proxyFactory.setTimeout(this.timeout);
        this.phprpcProxy = this.proxyFactory.useService(this.getServiceInterface());
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        if (this.phprpcProxy == null) {
            throw new IllegalStateException("PHPRPC_ClientInterceptor is not properly initialized - invoke 'prepare' before attempting any operations");
        }
        try {
            return invocation.getMethod().invoke(this.phprpcProxy, invocation.getArguments());
        }
        catch (InvocationTargetException ex) {
            throw ex.getTargetException();
        }
        catch (Throwable ex) {
            throw new RemoteProxyFailureException("Failed to invoke PHPRPC proxy for remote service [" + this.getServiceUrl() + "]", ex);
        }
    }
}

