/*
 * Decompiled with CFR 0.152.
 */
package org.scala_tools.maven.executions;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MainHelper {
    private static String escapeArgumentForScalacArgumentFile(String arg) {
        if (arg.matches(".*\\s.*")) {
            return '\"' + arg + '\"';
        }
        return arg;
    }

    private static String unescapeArgumentForScalacArgumentFile(String arg) {
        if (arg.charAt(0) == '\"' && arg.charAt(arg.length() - 1) == '\"') {
            return arg.substring(1, arg.length() - 1);
        }
        return arg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File createArgFile(List<String> args) throws IOException {
        File argFile = File.createTempFile("scala-maven-", ".args");
        PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(argFile)));
        try {
            for (String arg : args) {
                out.println(MainHelper.escapeArgumentForScalacArgumentFile(arg));
            }
        }
        finally {
            out.close();
        }
        return argFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> readArgFile(File argFile) throws IOException {
        ArrayList<String> back = new ArrayList<String>();
        BufferedReader in = new BufferedReader(new FileReader(argFile));
        try {
            String line = null;
            while ((line = in.readLine()) != null) {
                back.add(MainHelper.unescapeArgumentForScalacArgumentFile(line));
            }
        }
        finally {
            in.close();
        }
        return back;
    }

    public static void runMain(String mainClassName, List<String> args, ClassLoader cl) throws Exception {
        if (cl == null) {
            cl = Thread.currentThread().getContextClassLoader();
        }
        Class<?> mainClass = cl.loadClass(mainClassName);
        Method mainMethod = mainClass.getMethod("main", String[].class);
        int mods = mainMethod.getModifiers();
        if (mainMethod.getReturnType() != Void.TYPE || !Modifier.isStatic(mods) || !Modifier.isPublic(mods)) {
            throw new NoSuchMethodException("main");
        }
        String[] argArray = args.toArray(new String[args.size()]);
        mainMethod.invoke(null, new Object[]{argArray});
    }

    public static String locateJar(Class<?> c) throws Exception {
        String classLocation = c.getName().replace('.', '/') + ".class";
        ClassLoader loader = c.getClassLoader();
        URL location = loader == null ? ClassLoader.getSystemResource(classLocation) : loader.getResource(classLocation);
        if (location != null) {
            Pattern p = Pattern.compile("^.*file:(.*)!.*$");
            Matcher m = p.matcher(location.toString());
            if (m.find()) {
                return URLDecoder.decode(m.group(1), "UTF-8");
            }
            throw new ClassNotFoundException("Cannot parse location of '" + location + "'.  Probably not loaded from a Jar");
        }
        throw new ClassNotFoundException("Cannot find class '" + c.getName() + " using the classloader");
    }
}

