/*
 * Decompiled with CFR 0.152.
 */
package org.scala_tools.maven.executions;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.StringUtils;
import org.scala_tools.maven.executions.AbstractForkedJavaCommand;
import org.scala_tools.maven.executions.MainHelper;
import org.scala_tools.maven.executions.MainWithArgsInFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaCommand
extends AbstractForkedJavaCommand {
    private boolean _forceUseArgFile = false;

    public static String toMultiPath(List<String> paths) {
        return StringUtils.join(paths.iterator(), (String)File.pathSeparator);
    }

    public static String toMultiPath(String[] paths) {
        return StringUtils.join((Object[])paths, (String)File.pathSeparator);
    }

    public static String[] findFiles(File dir, String pattern) {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(dir);
        scanner.setIncludes(new String[]{pattern});
        scanner.addDefaultExcludes();
        scanner.scan();
        return scanner.getIncludedFiles();
    }

    public static String toClasspathString(ClassLoader cl) throws Exception {
        if (cl == null) {
            cl = Thread.currentThread().getContextClassLoader();
        }
        StringBuilder back = new StringBuilder();
        while (cl != null) {
            if (cl instanceof URLClassLoader) {
                URL[] urls;
                URLClassLoader ucl = (URLClassLoader)cl;
                for (URL url : urls = ucl.getURLs()) {
                    if (back.length() != 0) {
                        back.append(File.pathSeparatorChar);
                    }
                    back.append(url.getFile());
                }
            }
            cl = cl.getParent();
        }
        return back.toString();
    }

    public JavaCommand(AbstractMojo requester, String mainClassName, String classpath, String[] jvmArgs, String[] args, boolean forceUseArgFile) throws Exception {
        super(requester, mainClassName, classpath, jvmArgs, args);
        this._forceUseArgFile = forceUseArgFile;
    }

    @Override
    protected String[] buildCommand() throws Exception {
        ArrayList<String> back = new ArrayList<String>(2 + this.jvmArgs.size() + this.args.size());
        back.add(this.javaExec);
        if (!this._forceUseArgFile && this.lengthOf(this.args, 1L) + this.lengthOf(this.jvmArgs, 1L) < 400L) {
            back.addAll(this.jvmArgs);
            back.add(this.mainClassName);
            back.addAll(this.args);
        } else {
            File jarPath = new File(MainHelper.locateJar(MainHelper.class));
            this.requester.getLog().debug((CharSequence)("plugin jar to add :" + jarPath));
            this.addToClasspath(jarPath);
            back.addAll(this.jvmArgs);
            back.add(MainWithArgsInFile.class.getName());
            back.add(this.mainClassName);
            back.add(MainHelper.createArgFile(this.args).getCanonicalPath());
        }
        return back.toArray(new String[back.size()]);
    }

    private long lengthOf(List<String> l, long sepLength) throws Exception {
        long back = 0L;
        for (String str : l) {
            back += (long)str.length() + sepLength;
        }
        return back;
    }
}

