/*
 * Decompiled with CFR 0.152.
 */
package org.scala_tools.maven.executions;

import java.io.File;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.util.StringUtils;
import org.scala_tools.maven.StreamLogger;
import org.scala_tools.maven.StreamPiper;
import org.scala_tools.maven.executions.AbstractJavaMainCaller;

public abstract class AbstractForkedJavaCommand
extends AbstractJavaMainCaller {
    protected String javaExec;

    public AbstractForkedJavaCommand(AbstractMojo requester, String mainClassName, String classpath, String[] jvmArgs, String[] args) throws Exception {
        super(requester, mainClassName, classpath, jvmArgs, args);
        for (String key : System.getenv().keySet()) {
            this.env.add(key + "=" + System.getenv(key));
        }
        this.javaExec = System.getProperty("java.home");
        if (this.javaExec == null) {
            this.javaExec = System.getenv("JAVA_HOME");
            if (this.javaExec == null) {
                throw new IllegalStateException("Couldn't locate java, try setting JAVA_HOME environment variable.");
            }
        }
        this.javaExec = this.javaExec + File.separator + "bin" + File.separator + "java";
    }

    protected abstract String[] buildCommand() throws Exception;

    public void run(boolean displayCmd, boolean throwFailure) throws Exception {
        Object[] cmd = this.buildCommand();
        if (displayCmd) {
            this.requester.getLog().info((CharSequence)("cmd:  " + StringUtils.join((Object[])cmd, (String)" ")));
        } else if (this.requester.getLog().isDebugEnabled()) {
            this.requester.getLog().debug((CharSequence)("cmd:  " + StringUtils.join((Object[])cmd, (String)" ")));
        }
        ProcessBuilder pb = new ProcessBuilder((String[])cmd);
        if (!this.logOnly) {
            pb = pb.redirectErrorStream(true);
        }
        Process p = pb.start();
        if (this.logOnly) {
            new StreamLogger(p.getErrorStream(), this.requester.getLog(), true).start();
            new StreamLogger(p.getInputStream(), this.requester.getLog(), false).start();
        } else {
            new StreamPiper(p.getInputStream(), System.out).start();
            new StreamPiper(System.in, p.getOutputStream()).start();
        }
        int retVal = p.waitFor();
        if (throwFailure && retVal != 0) {
            throw new MojoFailureException("command line returned non-zero value:" + retVal);
        }
    }

    public void spawn(boolean displayCmd) throws Exception {
        Object[] cmd = this.buildCommand();
        if (displayCmd) {
            this.requester.getLog().info((CharSequence)("cmd:  " + StringUtils.join((Object[])cmd, (String)" ")));
        } else if (this.requester.getLog().isDebugEnabled()) {
            this.requester.getLog().debug((CharSequence)("cmd:  " + StringUtils.join((Object[])cmd, (String)" ")));
        }
        ProcessBuilder pb = new ProcessBuilder((String[])cmd);
        pb.start();
    }
}

