/*
 * Decompiled with CFR 0.152.
 */
package org.scala_tools.maven;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactCollector;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.filter.AndArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilder;
import org.apache.maven.shared.dependency.tree.filter.AncestorOrSelfDependencyNodeFilter;
import org.apache.maven.shared.dependency.tree.filter.AndDependencyNodeFilter;
import org.apache.maven.shared.dependency.tree.filter.DependencyNodeFilter;
import org.apache.maven.shared.dependency.tree.traversal.CollectingDependencyNodeVisitor;
import org.apache.maven.shared.dependency.tree.traversal.DependencyNodeVisitor;
import org.apache.maven.shared.dependency.tree.traversal.FilteringDependencyNodeVisitor;
import org.codehaus.plexus.util.StringUtils;
import org.scala_tools.maven.BasicArtifact;
import org.scala_tools.maven.VersionNumber;
import org.scala_tools.maven.dependency.CheckScalaVersionVisitor;
import org.scala_tools.maven.dependency.ScalaDistroArtifactFilter;
import org.scala_tools.maven.executions.AbstractJavaMainCaller;
import org.scala_tools.maven.executions.JavaCommand;
import org.scala_tools.maven.executions.JavaMainCaller;
import org.scala_tools.maven.executions.ReflectionJavaMainCaller;
import org.scala_tools.maven.executions.ScalaCommandWIthArgsInFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class ScalaMojoSupport
extends AbstractMojo {
    public static final String SCALA_GROUPID = "org.scala-lang";
    public static final String SCALA_LIBRARY_ARTIFACTID = "scala-library";
    protected MavenProject project;
    protected ArtifactFactory factory;
    protected ArtifactResolver resolver;
    protected ArtifactRepository localRepo;
    protected List<?> remoteRepos;
    protected BasicArtifact[] dependencies;
    protected BasicArtifact[] compilerPlugins;
    protected String[] jvmArgs;
    protected String[] args;
    protected String scalaClassName;
    protected String scalaVersion;
    protected boolean displayCmd;
    protected boolean fork = true;
    protected boolean forceUseArgFile = false;
    protected boolean checkMultipleScalaVersions;
    protected boolean failOnMultipleScalaVersions = false;
    protected MavenProjectBuilder mavenProjectBuilder;
    private ArtifactRepository localRepository;
    private ArtifactFactory artifactFactory;
    private ArtifactMetadataSource artifactMetadataSource;
    private ArtifactCollector artifactCollector;
    private DependencyTreeBuilder dependencyTreeBuilder;

    ScalaMojoSupport() {
    }

    protected Set<Artifact> resolveDependencyArtifacts(MavenProject theProject) throws Exception {
        AndArtifactFilter filter = new AndArtifactFilter();
        filter.add((ArtifactFilter)new ScopeArtifactFilter("test"));
        filter.add(new ArtifactFilter(){

            public boolean include(Artifact artifact) {
                return !artifact.isOptional();
            }
        });
        Set artifacts = theProject.createArtifacts(this.factory, "runtime", (ArtifactFilter)filter);
        for (Artifact artifact : artifacts) {
            this.resolver.resolve(artifact, this.remoteRepos, this.localRepo);
        }
        return artifacts;
    }

    protected Set<Artifact> resolveArtifactDependencies(Artifact artifact) throws Exception {
        Artifact pomArtifact = this.factory.createArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), "", "pom");
        MavenProject pomProject = this.mavenProjectBuilder.buildFromRepository(pomArtifact, this.remoteRepos, this.localRepo);
        return this.resolveDependencyArtifacts(pomProject);
    }

    protected void addToClasspath(String groupId, String artifactId, String version, Set<String> classpath) throws Exception {
        this.addToClasspath(this.factory.createArtifact(groupId, artifactId, version, "runtime", "jar"), classpath);
    }

    protected void addToClasspath(Artifact artifact, Set<String> classpath) throws Exception {
        this.resolver.resolve(artifact, this.remoteRepos, this.localRepo);
        classpath.add(artifact.getFile().getCanonicalPath());
        for (Artifact dep : this.resolveArtifactDependencies(artifact)) {
            classpath.add(dep.getFile().getCanonicalPath());
        }
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.checkScalaVersion();
            this.doExecute();
        }
        catch (MojoExecutionException exc) {
            throw exc;
        }
        catch (MojoFailureException exc) {
            throw exc;
        }
        catch (RuntimeException exc) {
            throw exc;
        }
        catch (Exception exc) {
            throw new MojoExecutionException("wrap: " + exc, exc);
        }
    }

    protected List<Dependency> getDependencies() {
        return this.project.getCompileDependencies();
    }

    protected void checkScalaVersion() throws Exception {
        String detectedScalaVersion = null;
        for (Dependency dep : this.getDependencies()) {
            if (!SCALA_GROUPID.equals(dep.getGroupId()) || !SCALA_LIBRARY_ARTIFACTID.equals(dep.getArtifactId())) continue;
            detectedScalaVersion = dep.getVersion();
        }
        if (StringUtils.isEmpty(detectedScalaVersion)) {
            if (!"pom".equals(this.project.getPackaging().toLowerCase())) {
                this.getLog().warn((CharSequence)"you don't define org.scala-lang:scala-library as a dependency of the project");
            }
        } else if (StringUtils.isNotEmpty((String)this.scalaVersion)) {
            if (!this.scalaVersion.equals(detectedScalaVersion)) {
                this.getLog().warn((CharSequence)"scala library version define in dependencies doesn't match the scalaVersion of the plugin");
            }
        } else {
            this.scalaVersion = detectedScalaVersion;
        }
        if (StringUtils.isEmpty((String)this.scalaVersion)) {
            throw new MojoFailureException("no scalaVersion detected or set");
        }
        if (this.checkMultipleScalaVersions) {
            this.checkCorrectVersionsOfScalaLibrary();
        }
    }

    private void checkCorrectVersionsOfScalaLibrary() throws Exception {
        this.getLog().info((CharSequence)"Checking for multiple versions of scala");
        this.checkArtifactForScalaVersion(this.dependencyTreeBuilder.buildDependencyTree(this.project, this.localRepository, this.artifactFactory, this.artifactMetadataSource, null, this.artifactCollector));
    }

    private void checkArtifactForScalaVersion(DependencyNode rootNode) throws Exception {
        CheckScalaVersionVisitor visitor = new CheckScalaVersionVisitor(this.scalaVersion, this.getLog());
        CollectingDependencyNodeVisitor collectingVisitor = new CollectingDependencyNodeVisitor();
        FilteringDependencyNodeVisitor firstPassVisitor = new FilteringDependencyNodeVisitor((DependencyNodeVisitor)collectingVisitor, this.createScalaDistroDependencyFilter());
        rootNode.accept((DependencyNodeVisitor)firstPassVisitor);
        AncestorOrSelfDependencyNodeFilter secondPassFilter = new AncestorOrSelfDependencyNodeFilter(collectingVisitor.getNodes());
        FilteringDependencyNodeVisitor filteredVisitor = new FilteringDependencyNodeVisitor((DependencyNodeVisitor)visitor, (DependencyNodeFilter)secondPassFilter);
        rootNode.accept((DependencyNodeVisitor)filteredVisitor);
        if (visitor.isFailed()) {
            if (this.failOnMultipleScalaVersions) {
                this.getLog().error((CharSequence)"Multiple versions of scala libraries detected!");
            } else {
                this.getLog().warn((CharSequence)"Multiple versions of scala libraries detected!");
            }
        }
    }

    private DependencyNodeFilter createScalaDistroDependencyFilter() {
        ArrayList<ScalaDistroArtifactFilter> filters = new ArrayList<ScalaDistroArtifactFilter>();
        filters.add(new ScalaDistroArtifactFilter());
        return new AndDependencyNodeFilter(filters);
    }

    protected abstract void doExecute() throws Exception;

    protected JavaMainCaller getScalaCommand() throws Exception {
        JavaMainCaller cmd = this.getEmptyScalaCommand(this.scalaClassName);
        cmd.addArgs(this.args);
        this.addCompilerPluginOptions(cmd);
        cmd.addJvmArgs(this.jvmArgs);
        return cmd;
    }

    protected JavaMainCaller getEmptyScalaCommand(String mainClass) throws Exception {
        AbstractJavaMainCaller cmd;
        if (this.fork) {
            if (new VersionNumber(this.scalaVersion).compareTo(new VersionNumber("2.8.0")) >= 0) {
                this.getLog().info((CharSequence)"use scala command with args in file");
                cmd = new ScalaCommandWIthArgsInFile(this, mainClass, this.getToolClasspath(), null, null);
            } else {
                this.getLog().info((CharSequence)("use java command with args in file forced : " + this.forceUseArgFile));
                cmd = new JavaCommand(this, mainClass, this.getToolClasspath(), null, null, this.forceUseArgFile);
            }
        } else {
            cmd = new ReflectionJavaMainCaller(this, mainClass, this.getToolClasspath(), null, null);
        }
        cmd.addJvmArgs("-Xbootclasspath/a:" + this.getBootClasspath());
        return cmd;
    }

    private String getToolClasspath() throws Exception {
        HashSet<String> classpath = new HashSet<String>();
        this.addToClasspath(SCALA_GROUPID, "scala-compiler", this.scalaVersion, classpath);
        if (this.dependencies != null) {
            for (BasicArtifact artifact : this.dependencies) {
                this.addToClasspath(artifact.groupId, artifact.artifactId, artifact.version, classpath);
            }
        }
        return JavaCommand.toMultiPath(classpath.toArray(new String[classpath.size()]));
    }

    private String getBootClasspath() throws Exception {
        HashSet<String> classpath = new HashSet<String>();
        this.addToClasspath(SCALA_GROUPID, SCALA_LIBRARY_ARTIFACTID, this.scalaVersion, classpath);
        return JavaCommand.toMultiPath(classpath.toArray(new String[classpath.size()]));
    }

    protected boolean isJavaSupportedByCompiler() {
        return new VersionNumber(this.scalaVersion).compareTo(new VersionNumber("2.7.2")) >= 0;
    }

    private void addCompilerPluginOptions(JavaMainCaller scalac) throws Exception {
        for (String plugin : this.getCompilerPlugins()) {
            scalac.addArgs("-Xplugin:" + plugin);
        }
    }

    private Set<String> getCompilerPlugins() throws Exception {
        HashSet<String> plugins = new HashSet<String>();
        if (this.compilerPlugins != null) {
            HashSet<String> ignoreClasspath = new HashSet<String>();
            this.addToClasspath(SCALA_GROUPID, "scala-compiler", this.scalaVersion, ignoreClasspath);
            this.addToClasspath(SCALA_GROUPID, SCALA_LIBRARY_ARTIFACTID, this.scalaVersion, ignoreClasspath);
            for (BasicArtifact artifact : this.compilerPlugins) {
                HashSet<String> pluginClassPath = new HashSet<String>();
                this.addToClasspath(artifact.groupId, artifact.artifactId, artifact.version, pluginClassPath);
                pluginClassPath.removeAll(ignoreClasspath);
                plugins.add((String)pluginClassPath.iterator().next());
            }
        }
        return plugins;
    }
}

