/*
 * Decompiled with CFR 0.152.
 */
package org.scala_tools.maven;

import java.io.File;
import java.util.HashSet;
import org.scala_tools.maven.ScalaMojoSupport;
import org.scala_tools.maven.executions.JavaCommand;

public class ScalaConsoleMojo
extends ScalaMojoSupport {
    protected String mainConsole;
    protected boolean useTestClasspath;
    protected boolean useRuntimeClasspath;
    protected File javaRebelPath;

    protected void doExecute() throws Exception {
        HashSet<String> classpath = new HashSet<String>();
        this.addToClasspath("org.scala-lang", "scala-compiler", this.scalaVersion, classpath);
        this.addToClasspath("org.scala-lang", "scala-library", this.scalaVersion, classpath);
        this.addToClasspath("jline", "jline", "0.9.94", classpath);
        classpath.addAll(this.project.getCompileClasspathElements());
        if (this.useTestClasspath) {
            classpath.addAll(this.project.getTestClasspathElements());
        }
        if (this.useRuntimeClasspath) {
            classpath.addAll(this.project.getRuntimeClasspathElements());
        }
        String classpathStr = JavaCommand.toMultiPath(classpath.toArray(new String[classpath.size()]));
        JavaCommand jcmd = new JavaCommand(this, this.mainConsole, classpathStr, this.jvmArgs, this.args, this.forceUseArgFile);
        if (this.javaRebelPath != null) {
            if (!this.javaRebelPath.exists()) {
                this.getLog().warn((CharSequence)("javaRevelPath '" + this.javaRebelPath.getCanonicalPath() + "' not found"));
            } else {
                jcmd.addJvmArgs("-noverify", "-javaagent:" + this.javaRebelPath.getCanonicalPath());
            }
        }
        jcmd.setLogOnly(false);
        jcmd.run(this.displayCmd);
    }
}

